/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.IntegerUtils;
import org.openecard.common.util.ShortUtils;

@Deprecated
public class CardCommands {
    private static final byte CLASS_BYTE = 0;

    public static byte[] getDataFromResponse(byte[] responseApdu) {
        return Arrays.copyOf(responseApdu, responseApdu.length - 2);
    }

    public static byte[] getResultFromResponse(byte[] responseApdu) {
        return Arrays.copyOfRange(responseApdu, responseApdu.length - 2, responseApdu.length);
    }

    public static InputAPDUInfoType makeApdu(byte[] cmd, List<byte[]> responses) {
        InputAPDUInfoType apdu = new InputAPDUInfoType();
        apdu.setInputAPDU(cmd);
        apdu.getAcceptableStatusCode().addAll(responses);
        return apdu;
    }

    public static Transmit makeTransmit(byte[] slotHandle, byte[] cmd, List<byte[]> responses) {
        Transmit t = new Transmit();
        t.setSlotHandle(slotHandle);
        InputAPDUInfoType apdu = CardCommands.makeApdu(cmd, responses);
        t.getInputAPDUInfo().add(apdu);
        return t;
    }

    private static byte[] buildContent(byte[] content) {
        byte[] lc = IntegerUtils.toByteArray(content.length);
        if (lc.length == 2) {
            lc = ByteUtils.concatenate((byte)0, lc);
        }
        content = ByteUtils.concatenate(lc, content);
        return content;
    }

    private static byte[] buildLength(short length, byte[] content) {
        if (length == 0) {
            return new byte[]{0};
        }
        byte[] data = content == null && length > 255 ? new byte[]{0} : new byte[]{};
        if (length > 255) {
            data = ByteUtils.concatenate(data, ShortUtils.toByteArray(length));
            return data;
        }
        data = ByteUtils.concatenate(data, (byte)length);
        return data;
    }

    public static byte[] genericCommand(byte cmd, byte[] p12, byte[] content) {
        byte[] apdu = new byte[]{0, cmd};
        apdu = ByteUtils.concatenate(apdu, p12);
        content = CardCommands.buildContent(content);
        apdu = ByteUtils.concatenate(apdu, content);
        return apdu;
    }

    public static byte[] genericCommand(byte cmd, byte[] p12, byte[] content, short length) {
        byte[] apdu = new byte[]{0, cmd};
        apdu = ByteUtils.concatenate(apdu, p12);
        content = CardCommands.buildContent(content);
        apdu = ByteUtils.concatenate(apdu, content);
        byte[] lenBytes = CardCommands.buildLength(length, content);
        apdu = ByteUtils.concatenate(apdu, lenBytes);
        return apdu;
    }

    public static byte[] genericCommand(byte cmd, byte[] p12) {
        byte[] apdu = new byte[]{0, cmd};
        apdu = ByteUtils.concatenate(apdu, p12);
        return apdu;
    }

    public static byte[] genericCommand(byte cmd, byte[] p12, short length) {
        byte[] apdu = new byte[]{0, cmd};
        apdu = ByteUtils.concatenate(apdu, p12);
        byte[] lenBytes = CardCommands.buildLength(length, null);
        apdu = ByteUtils.concatenate(apdu, lenBytes);
        return apdu;
    }

    public static byte[] addCommandChaining(byte[] apdu) {
        apdu[0] = (byte)(apdu[0] | 0x10);
        return apdu;
    }

    public static class Select {
        private static final byte COMMAND_SELECT = -92;
        private static final byte[] MF_fid = new byte[]{63, 0};

        public static List<byte[]> positiveResponses() {
            return new ArrayList<byte[]>(){
                {
                    this.add(new byte[]{-112, 0});
                }
            };
        }

        public static Transmit makeTransmit(byte[] slotHandle, byte[] cmd) {
            return CardCommands.makeTransmit(slotHandle, cmd, Select.positiveResponses());
        }

        private static byte[] generic(byte[] fid, byte p1, byte p2, short length) {
            byte[] p12 = new byte[]{p1, p2};
            byte[] apdu = (p2 & 0xC) != 12 ? (fid == null ? CardCommands.genericCommand((byte)-92, p12, length) : CardCommands.genericCommand((byte)-92, p12, fid, length)) : (fid == null ? CardCommands.genericCommand((byte)-92, p12) : CardCommands.genericCommand((byte)-92, p12, fid));
            return apdu;
        }

        private static byte[] generic(byte[] fid, byte p1, byte p2) {
            return Select.generic(fid, p1, p2, (short)255);
        }

        private static byte[] generic(byte p1, byte p2) {
            return Select.generic(null, p1, p2);
        }

        public static byte[] application(byte[] aid) {
            return Select.application(aid, (byte)12);
        }

        public static byte[] application_FCI(byte[] aid) {
            return Select.application(aid, (byte)0);
        }

        public static byte[] application_FCP(byte[] aid) {
            return Select.application(aid, (byte)4);
        }

        public static byte[] application_FMD(byte[] aid) {
            return Select.application(aid, (byte)8);
        }

        public static byte[] application_FCI_Ext(byte[] aid) {
            return Select.application(aid, (byte)0, (short)-1);
        }

        public static byte[] application_FCP_Ext(byte[] aid) {
            return Select.application(aid, (byte)4, (short)-1);
        }

        public static byte[] application_FMD_Ext(byte[] aid) {
            return Select.application(aid, (byte)8, (short)-1);
        }

        private static byte[] application(byte[] aid, byte p2) {
            return Select.generic(aid, (byte)4, p2);
        }

        private static byte[] application(byte[] aid, byte p2, short length) {
            return Select.generic(aid, (byte)4, p2, length);
        }

        public static byte[] DF(byte[] fid) {
            return Select.DF(fid, (byte)12);
        }

        public static byte[] DF_FCI(byte[] fid) {
            return Select.DF(fid, (byte)0);
        }

        public static byte[] DF_FCP(byte[] fid) {
            return Select.DF(fid, (byte)4);
        }

        public static byte[] DF_FMD(byte[] fid) {
            return Select.DF(fid, (byte)8);
        }

        public static byte[] DF_FCI_Ext(byte[] fid) {
            return Select.DF(fid, (byte)0, (short)-1);
        }

        public static byte[] DF_FCP_Ext(byte[] fid) {
            return Select.DF(fid, (byte)4, (short)-1);
        }

        public static byte[] DF_FMD_Ext(byte[] fid) {
            return Select.DF(fid, (byte)8, (short)-1);
        }

        private static byte[] DF(byte[] fid, byte p2) {
            return Select.generic(fid, (byte)1, p2);
        }

        private static byte[] DF(byte[] fid, byte p2, short length) {
            return Select.generic(fid, (byte)1, p2, length);
        }

        public static byte[] parent() {
            return Select.parent((byte)12);
        }

        public static byte[] parent_FCI() {
            return Select.parent((byte)0);
        }

        public static byte[] parent_FCP() {
            return Select.parent((byte)4);
        }

        public static byte[] parent_FMD() {
            return Select.parent((byte)8);
        }

        public static byte[] parent_FCI_Ext() {
            return Select.parent((byte)0, (short)-1);
        }

        public static byte[] parent_FCP_Ext() {
            return Select.parent((byte)4, (short)-1);
        }

        public static byte[] parent_FMD_Ext() {
            return Select.parent((byte)8, (short)-1);
        }

        private static byte[] parent(byte p2) {
            return Select.generic((byte)3, p2);
        }

        private static byte[] parent(byte p2, short length) {
            return Select.generic(null, (byte)3, p2, length);
        }

        public static byte[] EF(byte[] fid) {
            return Select.EF(fid, (byte)12);
        }

        public static byte[] EF_FCI(byte[] fid) {
            return Select.EF(fid, (byte)0);
        }

        public static byte[] EF_FCP(byte[] fid) {
            return Select.EF(fid, (byte)4);
        }

        public static byte[] EF_FMD(byte[] fid) {
            return Select.EF(fid, (byte)8);
        }

        public static byte[] EF_FCI_Ext(byte[] fid) {
            return Select.EF(fid, (byte)0, (short)-1);
        }

        public static byte[] EF_FCP_Ext(byte[] fid) {
            return Select.EF(fid, (byte)4, (short)-1);
        }

        public static byte[] EF_FMD_Ext(byte[] fid) {
            return Select.EF(fid, (byte)8, (short)-1);
        }

        private static byte[] EF(byte[] fid, byte p2) {
            return Select.generic(fid, (byte)2, p2);
        }

        private static byte[] EF(byte[] fid, byte p2, short length) {
            return Select.generic(fid, (byte)2, p2, length);
        }

        public static byte[] absolutePath(byte[] path) {
            return Select.absolutePath(path, (byte)12);
        }

        public static byte[] absolutePath_FCI(byte[] path) {
            return Select.absolutePath(path, (byte)0);
        }

        public static byte[] absolutePath_FCP(byte[] path) {
            return Select.absolutePath(path, (byte)4);
        }

        public static byte[] absolutePath_FMD(byte[] path) {
            return Select.absolutePath(path, (byte)8);
        }

        public static byte[] absolutePath_Ext(byte[] path) {
            return Select.absolutePath(path, (byte)12, (short)-1);
        }

        public static byte[] absolutePath_FCI_Ext(byte[] path) {
            return Select.absolutePath(path, (byte)0, (short)-1);
        }

        public static byte[] absolutePath_FCP_Ext(byte[] path) {
            return Select.absolutePath(path, (byte)4, (short)-1);
        }

        public static byte[] absolutePath_FMD_Ext(byte[] path) {
            return Select.absolutePath(path, (byte)8, (short)-1);
        }

        private static byte[] absolutePath(byte[] path, byte p2) {
            return Select.generic(path, (byte)8, p2);
        }

        private static byte[] absolutePath(byte[] path, byte p2, short length) {
            return Select.generic(path, (byte)8, p2, length);
        }

        public static byte[] relativePath(byte[] path) {
            return Select.relativePath(path, (byte)12);
        }

        public static byte[] relativePath_FCI(byte[] path) {
            return Select.relativePath(path, (byte)0);
        }

        public static byte[] relativePath_FCP(byte[] path) {
            return Select.relativePath(path, (byte)4);
        }

        public static byte[] relativePath_FMD(byte[] path) {
            return Select.relativePath(path, (byte)8);
        }

        public static byte[] relativePath_Ext(byte[] path) {
            return Select.relativePath(path, (byte)12, (short)-1);
        }

        public static byte[] relativePath_FCI_Ext(byte[] path) {
            return Select.relativePath(path, (byte)0, (short)-1);
        }

        public static byte[] relativePath_FCP_Ext(byte[] path) {
            return Select.relativePath(path, (byte)4, (short)-1);
        }

        public static byte[] relativePath_FMD_Ext(byte[] path) {
            return Select.relativePath(path, (byte)8, (short)-1);
        }

        private static byte[] relativePath(byte[] path, byte p2) {
            return Select.generic(path, (byte)9, p2);
        }

        private static byte[] relativePath(byte[] path, byte p2, short length) {
            return Select.generic(path, (byte)9, p2, length);
        }

        public static byte[] MF() {
            return Select.MF((byte)12);
        }

        public static byte[] MF_FCI() {
            return Select.MF((byte)0);
        }

        public static byte[] MF_FCP() {
            return Select.MF((byte)4);
        }

        public static byte[] MF_FMD() {
            return Select.MF((byte)8);
        }

        public static byte[] MF_FCI_Ext() {
            return Select.MF((byte)0, (short)-1);
        }

        public static byte[] MF_FCP_Ext() {
            return Select.MF((byte)4, (short)-1);
        }

        public static byte[] MF_FMD_Ext() {
            return Select.MF((byte)8, (short)-1);
        }

        private static byte[] MF(byte p2) {
            return Select.generic(MF_fid, (byte)0, p2);
        }

        private static byte[] MF(byte p2, short length) {
            return Select.generic(MF_fid, (byte)0, p2, length);
        }
    }

    public static class Read {
        private static final byte COMMAND_READ_BINARY1 = -80;
        private static final byte COMMAND_READ_BINARY2 = -79;
        private static final byte COMMAND_READ_RECORD1 = -78;
        private static final byte COMMAND_READ_RECORD2 = -77;

        public static List<byte[]> positiveResponses() {
            return new ArrayList<byte[]>(){
                {
                    this.add(new byte[]{-112, 0});
                    this.add(new byte[]{98, -126});
                }
            };
        }

        public static Transmit makeTransmit(byte[] slotHandle, byte[] cmd) {
            return CardCommands.makeTransmit(slotHandle, cmd, Read.positiveResponses());
        }

        private static byte[] genericBinary(byte cmd, byte[] p12, byte[] content, short length) {
            if (p12.length == 1) {
                p12 = ByteUtils.concatenate((byte)0, p12);
            }
            byte[] apdu = content == null ? CardCommands.genericCommand(cmd, p12, length) : CardCommands.genericCommand(cmd, p12, content, length);
            return apdu;
        }

        public static byte[] binaryWithShortId(byte shortId, short offset, short len) {
            if (offset > 255) {
                byte[] dataBytes = ShortUtils.toByteArray(offset);
                dataBytes = ByteUtils.concatenate((byte)dataBytes.length, dataBytes);
                dataBytes = ByteUtils.concatenate((byte)84, dataBytes);
                dataBytes = ByteUtils.concatenate((byte)dataBytes.length, dataBytes);
                dataBytes = ByteUtils.concatenate((byte)83, dataBytes);
                return Read.genericBinary((byte)-79, new byte[]{0, shortId}, dataBytes, len);
            }
            byte p1 = (byte)(0x1F & shortId | 0x80);
            return Read.genericBinary((byte)-80, new byte[]{p1, (byte)offset}, null, len);
        }

        public static byte[] binaryWithShortId(byte shortId, short offset) {
            return Read.binaryWithShortId(shortId, offset, (short)255);
        }

        public static byte[] binary(short offset, short len) {
            byte[] p12 = ShortUtils.toByteArray(offset);
            if (p12.length == 2) {
                p12[0] = (byte)(p12[0] & 0x7F);
            }
            return Read.genericBinary((byte)-80, p12, null, len);
        }

        public static byte[] binary(short offset) {
            return Read.binary(offset, (short)255);
        }

        public static byte[] binary() {
            return Read.binary((short)0);
        }

        public static byte[] binaryWithExtraOffset(short fileId, short offset, short len) {
            byte[] p12 = ShortUtils.toByteArray(fileId);
            byte[] content = ShortUtils.toByteArray(offset);
            content = ByteUtils.concatenate((byte)content.length, content);
            content = ByteUtils.concatenate((byte)84, content);
            return Read.genericBinary((byte)-79, p12, content, len);
        }

        public static byte[] binaryWithExtraOffset(short fileId, short offset) {
            return Read.binaryWithExtraOffset(fileId, offset, (short)255);
        }

        private static byte[] genericRecord(byte shortId, byte readType, byte record, short length) {
            byte p1 = record;
            byte p2 = (byte)(shortId << 3);
            p2 = (byte)(p2 | readType & 7);
            byte[] apdu = CardCommands.genericCommand((byte)-78, new byte[]{p1, p2}, length);
            return apdu;
        }

        private static byte[] genericRecord(byte shortId, byte readType, byte record, short offset, short length) {
            byte p1 = record;
            byte p2 = (byte)(shortId << 3);
            p2 = (byte)(p2 | readType & 7);
            byte[] content = ShortUtils.toByteArray(offset);
            content = ByteUtils.concatenate((byte)content.length, content);
            content = ByteUtils.concatenate((byte)84, content);
            byte[] apdu = CardCommands.genericCommand((byte)-78, new byte[]{p1, p2}, length);
            return apdu;
        }

        public static byte[] recordNumber(byte number) {
            return Read.genericRecord((byte)0, (byte)4, number, (short)255);
        }

        public static byte[] recordNumber_Ext(byte number) {
            return Read.genericRecord((byte)0, (byte)4, number, (short)-1);
        }

        public static byte[] recordNumberWithShortId(byte shortId, byte number) {
            return Read.genericRecord(shortId, (byte)4, number, (short)255);
        }

        public static byte[] recordNumberWithShortId_Ext(byte shortId, byte number) {
            return Read.genericRecord(shortId, (byte)4, number, (short)-1);
        }

        public static byte[] recordsFromNumber(byte number) {
            return Read.genericRecord((byte)0, (byte)5, number, (short)255);
        }

        public static byte[] recordsNumber_Ext(byte number) {
            return Read.genericRecord((byte)0, (byte)5, number, (short)-1);
        }
    }

    public static class PerformSecurityOperation {
        private static final byte COMMAND_PERFORM_SECURITY_OPERATION = 42;
        private static final byte VERIFY_SELF_DESCRIPTIVE_CERTIFICATE = -66;
        private static final byte VERIFY_NOT_SELF_DESCRIPTIVE_CERTIFICATE = -82;

        public static byte[] verifySelfDescriptiveCertificate(byte[] certificate) {
            byte[] verifySelfCert = new byte[]{0, -66};
            return CardCommands.genericCommand((byte)42, verifySelfCert, certificate);
        }

        public static byte[] verifyNotSelfDescriptiveCertificate(byte[] certificate) {
            byte[] verifyNotSelfCert = new byte[]{0, -82};
            return CardCommands.genericCommand((byte)42, verifyNotSelfCert, certificate);
        }

        public static byte[] computeDigitalSignature(byte[] input) {
            byte[] p12 = new byte[]{-98, -102};
            return CardCommands.genericCommand((byte)42, p12, input, (short)0);
        }

        public static byte[] decipher(byte[] input, short length) {
            byte[] p12 = new byte[]{-128, -122};
            return CardCommands.genericCommand((byte)42, p12, input, length);
        }
    }

    public static class GeneralAuthenticate {
        private static final byte COMMAND_GENERAL_AUTHENTICATE = -122;
        private static final byte GENERAL_AUTHENTICATION_DATA_TAG = 124;
        private static final byte[] p12 = new byte[]{0, 0};

        public static byte[] getNonce() {
            byte[] command = CardCommands.genericCommand((byte)-122, p12, new byte[]{124, 0}, (short)0);
            return CardCommands.addCommandChaining(command);
        }

        public static byte[] generic(byte tag, byte[] content, boolean commandChaining) {
            byte[] mappingData = ByteUtils.concatenate(new byte[]{tag, (byte)content.length}, content);
            byte[] data = ByteUtils.concatenate(new byte[]{124, (byte)mappingData.length}, mappingData);
            byte[] command = CardCommands.genericCommand((byte)-122, p12, data, (short)0);
            if (commandChaining) {
                return CardCommands.addCommandChaining(command);
            }
            return command;
        }
    }

    public static class ManageSecurityEnvironment {
        private static final byte COMMAND_MANAGE_SECURITY_ENVIRONMENT = 34;

        public static byte[] setDST(byte[] data) {
            byte[] p12 = new byte[]{-127, -74};
            data = ByteUtils.concatenate(new byte[]{-125, (byte)data.length}, data);
            return CardCommands.genericCommand((byte)34, p12, data);
        }

        @Deprecated
        public static byte[] mseSelectPrKeyIntAuth(byte keyRef, byte algId) {
            byte[] p12 = new byte[]{65, -92};
            byte[] data = new byte[]{-124, 1, keyRef, -128, 1, algId};
            return CardCommands.genericCommand((byte)34, p12, data);
        }

        @Deprecated
        public static byte[] mseSelectPrKeySignature(byte keyRef, byte algId) {
            byte[] p12 = new byte[]{65, -74};
            byte[] data = new byte[]{-124, 1, keyRef, -128, 1, algId};
            return CardCommands.genericCommand((byte)34, p12, data);
        }

        @Deprecated
        public static byte[] mseSelectPrKeyDecipher(byte keyRef, byte algId) {
            byte[] p12 = new byte[]{65, -72};
            byte[] data = new byte[]{-124, 1, keyRef, -128, 1, algId};
            return CardCommands.genericCommand((byte)34, p12, data);
        }

        @Deprecated
        public static byte[] mseSelectPubKeyCertVerification(byte[] keyRef) {
            byte[] p12 = new byte[]{-127, -74};
            byte[] data = ByteUtils.concatenate(new byte[]{-125, (byte)keyRef.length}, keyRef);
            return CardCommands.genericCommand((byte)34, p12, data);
        }

        @Deprecated
        public static byte[] mseSelectPubKeyExtAuth(byte[] keyRef, byte algId) {
            byte[] p12 = new byte[]{-127, -92};
            byte[] data = ByteUtils.concatenate(ByteUtils.concatenate(new byte[]{-125, (byte)keyRef.length}, keyRef), new byte[]{-128, 1, algId});
            return CardCommands.genericCommand((byte)34, p12, data);
        }

        public static class setAT {
            public static byte[] PACE(byte[] oid, byte passwordType, byte[] chat) {
                byte[] p12 = new byte[]{-63, -92};
                byte[] data = ByteUtils.concatenate(new byte[]{-128, (byte)oid.length}, oid);
                data = ByteUtils.concatenate(data, new byte[]{-125, 1, passwordType});
                if (chat != null) {
                    data = ByteUtils.concatenate(data, chat);
                }
                return CardCommands.genericCommand((byte)34, p12, data);
            }

            public static byte[] TA(byte[] oid, byte[] chr, byte[] pkPCD, byte[] aad) {
                byte[] p12 = new byte[]{-127, -92};
                byte[] data = ByteUtils.concatenate(new byte[]{-128, (byte)oid.length}, oid);
                if (chr != null) {
                    data = ByteUtils.concatenate(data, ByteUtils.concatenate(new byte[]{-125, (byte)chr.length}, chr));
                }
                if (pkPCD != null) {
                    data = ByteUtils.concatenate(data, ByteUtils.concatenate(new byte[]{-111, (byte)pkPCD.length}, pkPCD));
                }
                if (aad != null) {
                    data = ByteUtils.concatenate(data, aad);
                }
                return CardCommands.genericCommand((byte)34, p12, data);
            }

            public static byte[] CA(byte[] oid, byte[] keyID) {
                byte[] p12 = new byte[]{65, -92};
                byte[] data = ByteUtils.concatenate(new byte[]{-128, (byte)oid.length}, oid);
                if (keyID != null) {
                    keyID = ByteUtils.cutLeadingNullByte(keyID);
                    data = ByteUtils.concatenate(data, ByteUtils.concatenate(new byte[]{-124, (byte)keyID.length}, keyID));
                }
                return CardCommands.genericCommand((byte)34, p12, data);
            }
        }
    }

    public static class ExternalAuthenticate {
        private static final byte COMMAND_EXTERNAL_AUTHENTICATE = -126;

        public static byte[] generic(byte[] data) {
            byte[] p12 = new byte[]{0, 0};
            return CardCommands.genericCommand((byte)-126, p12, data);
        }
    }

    public static class GetChallenge {
        private static final byte COMMAND_GET_CHALLENGE = -124;

        public static byte[] generic() {
            return CardCommands.genericCommand((byte)-124, new byte[]{0, 0}, (short)8);
        }

        public static byte[] generic(short le) {
            return CardCommands.genericCommand((byte)-124, new byte[]{0, 0}, le);
        }
    }

    public static class Verify {
        private static final byte COMMAND_VERIFY = 32;

        public static byte[] generic(byte p1, byte p2, byte[] data) {
            return CardCommands.genericCommand((byte)32, new byte[]{p1, p2}, data);
        }
    }

    public static class InternalAuthenticate {
        private static final byte COMMAND_INTERNAL_AUTHENTICATE = -120;

        public static byte[] generic(byte[] data, short le) {
            return CardCommands.genericCommand((byte)-120, new byte[]{0, 0}, data, le);
        }
    }
}

