/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1Encodable;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1Sequence;

public class SecurityInfo {
    private ASN1ObjectIdentifier identifier;
    private ASN1Encodable requiredData;
    private ASN1Encodable optionalData;

    public static SecurityInfo getInstance(Object obj) {
        if (obj == null || obj instanceof SecurityInfo) {
            return (SecurityInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new SecurityInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public SecurityInfo(ASN1Sequence seq) {
        if (seq.size() == 2) {
            this.identifier = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
            this.requiredData = seq.getObjectAt(1);
        } else if (seq.size() == 3) {
            this.identifier = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
            this.requiredData = seq.getObjectAt(1);
            this.optionalData = seq.getObjectAt(2);
        } else {
            throw new IllegalArgumentException("sequence wrong size for CertificateList");
        }
    }

    public SecurityInfo(ASN1ObjectIdentifier contentType, ASN1Encodable requiredData) {
        this.identifier = contentType;
        this.requiredData = requiredData;
    }

    public SecurityInfo(ASN1ObjectIdentifier contentType, ASN1Encodable requiredData, ASN1Encodable optionalData) {
        this.identifier = contentType;
        this.requiredData = requiredData;
        this.optionalData = optionalData;
    }

    public String getIdentifier() {
        return this.identifier.toString();
    }

    public ASN1Encodable getRequiredData() {
        return this.requiredData;
    }

    public ASN1Encodable getOptionalData() {
        return this.optionalData;
    }
}

