/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.StatusLine;
import org.openecard.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.openecard.apache.http.protocol.BasicHttpContext;
import org.openecard.apache.http.protocol.HttpRequestExecutor;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.TlsProtocolHandler;
import org.openecard.common.io.LimitedInputStream;
import org.openecard.common.io.ProxySettings;
import org.openecard.control.ControlException;
import org.openecard.control.module.tctoken.TCTokenException;
import org.openecard.control.module.tctoken.TlsAuthenticationCertSave;
import org.openecard.crypto.tls.ClientCertDefaultTlsClient;
import org.openecard.transport.httpcore.HttpRequestHelper;
import org.openecard.transport.httpcore.StreamHttpClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCTokenGrabber {
    private static final Logger logger = LoggerFactory.getLogger(TCTokenGrabber.class);

    public static InputStream getStream(URL url) throws TCTokenException, MalformedURLException, KeyStoreException, IOException, GeneralSecurityException, HttpException, URISyntaxException {
        HttpEntity entity = null;
        boolean finished = false;
        block3: while (!finished) {
            logger.info("Trying to load TCToken from: {}", (Object)url);
            String protocol = url.getProtocol();
            String hostname = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            String resource = url.getFile();
            if (!"https".equals(protocol)) {
                throw new ControlException("Specified URL is not a https-URL.");
            }
            TlsAuthenticationCertSave tlsAuth = new TlsAuthenticationCertSave();
            tlsAuth.setHostname(hostname);
            ClientCertDefaultTlsClient tlsClient = new ClientCertDefaultTlsClient(hostname);
            tlsClient.setAuthentication(tlsAuth);
            tlsClient.setClientVersion(ProtocolVersion.TLSv11);
            Socket socket = ProxySettings.getDefault().getSocket(hostname, port);
            TlsProtocolHandler h = new TlsProtocolHandler(socket.getInputStream(), socket.getOutputStream());
            h.connect(tlsClient);
            StreamHttpClientConnection conn = new StreamHttpClientConnection(h.getInputStream(), h.getOutputStream());
            BasicHttpContext ctx = new BasicHttpContext();
            HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
            BasicHttpEntityEnclosingRequest req = new BasicHttpEntityEnclosingRequest("GET", resource);
            req.setParams(conn.getParams());
            HttpRequestHelper.setDefaultHeader(req, hostname);
            req.setHeader("Accept", "text/xml, */*;q=0.8");
            req.setHeader("Accept-Charset", "utf-8, *;q=0.8");
            HttpResponse response = httpexecutor.execute(req, conn, ctx);
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            switch (statusCode) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    Header[] headers = response.getHeaders("Location");
                    if (headers.length > 0) {
                        String uri = headers[0].getValue();
                        url = new URL(uri);
                        continue block3;
                    }
                    throw new TCTokenException("TCToken cannot be retrieved. Missing Location header in HTTP response.");
                }
            }
            conn.receiveResponseEntity(response);
            entity = response.getEntity();
            finished = true;
        }
        LimitedInputStream is = new LimitedInputStream(entity.getContent());
        return is;
    }

    public static String getResource(URL url) throws TCTokenException {
        FilterInputStream is = null;
        try {
            int num;
            is = new LimitedInputStream(TCTokenGrabber.getStream(url));
            StringBuilder sb = new StringBuilder(2048);
            byte[] buf = new byte[1024];
            while ((num = ((LimitedInputStream)is).read(buf)) != -1) {
                sb.append(new String(buf, 0, num));
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new TCTokenException(e.getMessage(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ignore) {}
        }
    }
}

