/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.TlsClient;
import org.openecard.bouncycastle.crypto.tls.TlsClientContext;
import org.openecard.bouncycastle.crypto.tls.TlsCompression;
import org.openecard.bouncycastle.crypto.tls.TlsDeflateCompression;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsNullCompression;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;

public abstract class AbstractTlsClient
implements TlsClient {
    protected TlsClientContext context;
    private Hashtable<Integer, byte[]> clientExtensions = new Hashtable();
    protected int selectedCipherSuite;
    protected int selectedCompressionMethod;
    private boolean secureRenegotiation;
    private final String fullyQualifiedDomainName;
    private ProtocolVersion clientVersion = ProtocolVersion.TLSv10;
    private byte[] sessionID;

    protected AbstractTlsClient(String fqdn) {
        this.fullyQualifiedDomainName = fqdn;
        ByteArrayOutputStream serverList = new ByteArrayOutputStream();
        ByteArrayOutputStream sniData = new ByteArrayOutputStream();
        try {
            serverList.write(0);
            TlsUtils.writeOpaque16(this.fullyQualifiedDomainName.getBytes(), serverList);
            TlsUtils.writeOpaque16(serverList.toByteArray(), sniData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.clientExtensions.put(new Integer(0), sniData.toByteArray());
    }

    @Override
    public final void init(TlsClientContext context) {
        this.context = context;
    }

    public void addClientExtension(Integer i, byte[] b) {
        this.clientExtensions.put(i, b);
    }

    public void removeClientExtension(Integer i) {
        this.clientExtensions.remove(i);
    }

    @Override
    public void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    @Override
    public final ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public final short[] getCompressionMethods() {
        return new short[]{0, 1};
    }

    @Override
    public final Hashtable<Integer, byte[]> getClientExtensions() throws IOException {
        return this.clientExtensions;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        if (serverVersion.getFullVersion() < ProtocolVersion.TLSv10.getFullVersion()) {
            throw new TlsFatalAlert(47);
        }
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    @Override
    public void notifySelectedCompressionMethod(short selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    @Override
    public void notifySecureRenegotiation(boolean secureNegotiation) throws IOException {
        this.secureRenegotiation = secureNegotiation;
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) {
    }

    @Override
    public final TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
            case 1: {
                return new TlsDeflateCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public byte[] getSessionID() {
        return this.sessionID;
    }

    @Override
    public TlsClientContext getClientContext() {
        return this.context;
    }
}

