/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.gui;

import java.util.TreeMap;
import org.openecard.common.I18n;
import org.openecard.crypto.common.asn1.cvc.CHAT;
import org.openecard.gui.definition.BoxItem;
import org.openecard.gui.definition.Checkbox;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.definition.ToggleText;
import org.openecard.sal.protocol.eac.EACData;

public class CHATStep
extends Step {
    public static final String STEP_ID = "PROTOCOL_EAC_GUI_STEP_CHAT";
    public static final String TITLE = "step_chat_title";
    public static final String DESCRIPTION = "step_chat_description";
    public static final String NOTE = "step_chat_note";
    public static final String NOTE_CONTENT = "step_chat_note_content";
    public static final String CHAT_BOXES = "CHATCheckBoxs";
    private final I18n lang = I18n.getTranslation("eac");
    private final EACData eacData;

    public CHATStep(EACData eacData) {
        super(STEP_ID);
        this.eacData = eacData;
        this.setTitle(this.lang.translationForKey(TITLE, new Object[0]));
        this.setDescription(this.lang.translationForKey(DESCRIPTION, new Object[0]));
        this.addElements();
    }

    private void addElements() {
        int i;
        Text decription = new Text();
        String decriptionText = this.lang.translationForKey(DESCRIPTION, this.eacData.certificateDescription.getSubjectName());
        decription.setText(decriptionText);
        this.getInputInfoUnits().add(decription);
        Checkbox readAccessCheckBox = new Checkbox(CHAT_BOXES);
        TreeMap<CHAT.DataGroup, Boolean> requiredReadAccess = this.eacData.requiredCHAT.getReadAccess();
        TreeMap<CHAT.DataGroup, Boolean> optionalReadAccess = this.eacData.optionalCHAT.getReadAccess();
        TreeMap<CHAT.SpecialFunction, Boolean> requiredSpecialFunctions = this.eacData.requiredCHAT.getSpecialFunctions();
        TreeMap<CHAT.SpecialFunction, Boolean> optionalSpecialFunctions = this.eacData.optionalCHAT.getSpecialFunctions();
        CHAT.DataGroup[] dataGroups = CHAT.DataGroup.values();
        CHAT.SpecialFunction[] specialFunctions = CHAT.SpecialFunction.values();
        for (i = 0; i < 21; ++i) {
            CHAT.DataGroup dataGroup = dataGroups[i];
            if (requiredReadAccess.get((Object)dataGroup).booleanValue()) {
                readAccessCheckBox.getBoxItems().add(this.makeBoxItem(dataGroup, true, true));
                continue;
            }
            if (!optionalReadAccess.get((Object)dataGroup).booleanValue()) continue;
            readAccessCheckBox.getBoxItems().add(this.makeBoxItem(dataGroup, true, false));
        }
        for (i = 0; i < 8; ++i) {
            CHAT.SpecialFunction specialFunction = specialFunctions[i];
            if (requiredSpecialFunctions.get((Object)specialFunction).booleanValue()) {
                readAccessCheckBox.getBoxItems().add(this.makeBoxItem(specialFunction, true, true));
                continue;
            }
            if (!optionalSpecialFunctions.get((Object)specialFunction).booleanValue()) continue;
            readAccessCheckBox.getBoxItems().add(this.makeBoxItem(specialFunction, true, false));
        }
        this.getInputInfoUnits().add(readAccessCheckBox);
        ToggleText requestedDataDescription = new ToggleText();
        requestedDataDescription.setTitle(this.lang.translationForKey(NOTE, new Object[0]));
        requestedDataDescription.setText(this.lang.translationForKey(NOTE_CONTENT, new Object[0]));
        requestedDataDescription.setCollapsed(false);
        this.getInputInfoUnits().add(requestedDataDescription);
    }

    private BoxItem makeBoxItem(Enum<?> value, boolean checked, boolean disabled) {
        BoxItem item = new BoxItem();
        item.setName(value.name());
        item.setChecked(checked);
        item.setDisabled(disabled);
        item.setText(this.lang.translationForKey(value.name(), new Object[0]));
        return item;
    }
}

