/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Exchanger;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.definition.Step;

public class SwingStepResult
implements StepResult {
    public Exchanger<Void> syncPoint = new Exchanger();
    private Step step;
    private ResultStatus status;
    private List<OutputInfoUnit> results;

    public SwingStepResult(Step step) {
        this(step, null);
    }

    public SwingStepResult(Step step, ResultStatus status) {
        this.step = step;
        this.status = status;
    }

    public void setResultStatus(ResultStatus status) {
        this.status = status;
    }

    public void setResult(List<OutputInfoUnit> results) {
        this.results = results;
    }

    @Override
    public Step getStep() {
        return this.step;
    }

    @Override
    public String getStepID() {
        return this.step.getID();
    }

    @Override
    public ResultStatus getStatus() {
        this.synchronize();
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOK() {
        this.synchronize();
        SwingStepResult swingStepResult = this;
        synchronized (swingStepResult) {
            return this.getStatus() == ResultStatus.OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBack() {
        this.synchronize();
        SwingStepResult swingStepResult = this;
        synchronized (swingStepResult) {
            return this.getStatus() == ResultStatus.BACK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        this.synchronize();
        SwingStepResult swingStepResult = this;
        synchronized (swingStepResult) {
            return this.getStatus() == ResultStatus.CANCEL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OutputInfoUnit> getResults() {
        this.synchronize();
        SwingStepResult swingStepResult = this;
        synchronized (swingStepResult) {
            if (this.results == null) {
                this.results = Collections.unmodifiableList(new LinkedList());
            }
            return this.results;
        }
    }

    private void synchronize() {
        if (this.status == null) {
            try {
                this.syncPoint.exchange(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

