/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.annotation.Nonnull;

public class SocketWrapper
extends Socket {
    private final Socket parent;
    private final InputStream in;
    private final OutputStream out;

    public SocketWrapper(@Nonnull Socket parent, @Nonnull InputStream in, @Nonnull OutputStream out) throws IOException {
        this.parent = parent;
        this.in = in;
        this.out = out;
        if (!parent.isConnected()) {
            throw new IOException("Socket is not connected.");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.parent.getInputStream();
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.parent.getInputStream();
        return this.out;
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.parent.bind(bindpoint);
    }

    @Override
    public synchronized void close() throws IOException {
        this.parent.close();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.parent.connect(endpoint);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.parent.connect(endpoint, timeout);
    }

    @Override
    public SocketChannel getChannel() {
        return this.parent.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.parent.getInetAddress();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.parent.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.parent.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.parent.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.parent.getLocalSocketAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.parent.getOOBInline();
    }

    @Override
    public int getPort() {
        return this.parent.getPort();
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.parent.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.parent.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.parent.getReuseAddress();
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.parent.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.parent.getSoLinger();
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.parent.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.parent.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.parent.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return this.parent.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.parent.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.parent.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.parent.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.parent.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.parent.sendUrgentData(data);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.parent.setKeepAlive(on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.parent.setOOBInline(on);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.parent.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.parent.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.parent.setReuseAddress(on);
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.parent.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.parent.setSoLinger(on, linger);
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.parent.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.parent.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.parent.setTrafficClass(tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.parent.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.parent.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.parent.toString();
    }
}

