/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import generated.TCTokenType;
import java.net.URL;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.ValueValidator;
import org.openecard.control.module.tctoken.TCTokenException;

public class TCTokenVerifier {
    private TCTokenType token;

    public TCTokenVerifier(TCTokenType token) {
        this.token = token;
    }

    public void verify() throws TCTokenException {
        if (this.token == null) {
            throw new IllegalStateException();
        }
        try {
            this.verifyServerAddress();
            this.verifySessionIdentifier();
            this.verifyRefreshAddress();
            this.verifyBinding();
            this.verifyPathSecurityParameters();
            this.verifyPathSecurityProtocol();
        }
        catch (TCTokenException e) {
            throw new TCTokenException("TCToken is malformed", e);
        }
    }

    public void verifyServerAddress() throws TCTokenException {
        try {
            String value = this.token.getServerAddress();
            this.assertURL(value);
            this.assertRequired(value);
        }
        catch (TCTokenException e) {
            throw new TCTokenException("Malformed ServerAddress");
        }
    }

    public void verifySessionIdentifier() throws TCTokenException {
        try {
            String value = this.token.getSessionIdentifier();
            this.assertRequired(value);
        }
        catch (TCTokenException e) {
            throw new TCTokenException("Malformed SessionIdentifier");
        }
    }

    public void verifyRefreshAddress() throws TCTokenException {
        try {
            String value = this.token.getRefreshAddress();
            this.assertURL(value);
            this.assertRequired(value);
        }
        catch (TCTokenException e) {
            throw new TCTokenException("Malformed RefreshAddress");
        }
    }

    public void verifyBinding() throws TCTokenException {
        try {
            String value = this.token.getBinding();
            this.assertRequired(value);
            this.checkEqual(value, "urn:liberty:paos:2006-08");
        }
        catch (TCTokenException e) {
            throw new TCTokenException("Malformed Binding");
        }
    }

    public void verifyPathSecurityProtocol() throws TCTokenException {
        try {
            String value = this.token.getPathSecurityProtocol();
            if (!this.checkEmpty(value)) {
                this.checkEqualOR(value, "urn:ietf:rfc:4346", "urn:ietf:rfc:4279", "urn:ietf:rfc:5487");
            }
        }
        catch (TCTokenException e) {
            throw new TCTokenException("Malformed PathSecurityProtocol");
        }
    }

    public void verifyPathSecurityParameters() throws TCTokenException {
        try {
            TCTokenType.PathSecurityParameters psp;
            if ((this.token.getPathSecurityProtocol().equals("urn:ietf:rfc:4279") || this.token.getPathSecurityProtocol().equals("urn:ietf:rfc:5487")) && !this.checkEmpty(psp = this.token.getPathSecurityParameters())) {
                this.assertRequired(psp.getPSK());
                this.checkPSKLength(ByteUtils.toHexString(psp.getPSK()));
            }
        }
        catch (TCTokenException e) {
            throw new TCTokenException("Malformed PathSecurityParameters");
        }
    }

    private boolean checkEmpty(Object value) {
        if (value != null) {
            return value instanceof String ? ((String)value).isEmpty() : (value instanceof URL ? ((URL)value).toString().isEmpty() : value instanceof byte[] && ((byte[])value).length == 0);
        }
        return true;
    }

    private void checkEqual(String value, String equal) throws TCTokenException {
        if (!value.equals(equal)) {
            throw new TCTokenException("Element is not equal to " + equal);
        }
    }

    private void checkEqualOR(String value, String ... equal) throws TCTokenException {
        for (String string : equal) {
            if (!value.equals(string)) continue;
            return;
        }
        throw new TCTokenException();
    }

    private void assertRequired(Object value) throws TCTokenException {
        if (this.checkEmpty(value)) {
            throw new TCTokenException("Element is required.");
        }
    }

    private void assertURL(Object value) throws TCTokenException {
        try {
            new URL(value.toString());
        }
        catch (Exception e) {
            throw new TCTokenException("Malformed URL");
        }
    }

    private void checkPSKLength(String value) throws TCTokenException {
        if (!ValueValidator.checkPSKStrength(value)) {
            throw new TCTokenException("The number of bytes in the PSK is too small.");
        }
    }
}

