/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv;

import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.LongUtils;

public class Tag {
    public static final Tag BOOLEAN_TAG = new Tag(TagClass.UNIVERSAL, true, 1L);
    public static final Tag INTEGER_TAG = new Tag(TagClass.UNIVERSAL, true, 2L);
    public static final Tag BITSTRING_TAG = new Tag(TagClass.UNIVERSAL, true, 3L);
    public static final Tag OCTETSTRING_TAG = new Tag(TagClass.UNIVERSAL, true, 4L);
    public static final Tag NULL_TAG = new Tag(TagClass.UNIVERSAL, true, 5L);
    public static final Tag OID_TAG = new Tag(TagClass.UNIVERSAL, true, 6L);
    public static final Tag REAL_TAG = new Tag(TagClass.UNIVERSAL, true, 9L);
    public static final Tag ENUMERATED_TAG = new Tag(TagClass.UNIVERSAL, true, 10L);
    public static final Tag EMBEDDED_PDV_TAG = new Tag(TagClass.UNIVERSAL, false, 11L);
    public static final Tag RELATIVE_OID_TAG = new Tag(TagClass.UNIVERSAL, true, 13L);
    public static final Tag SEQUENCE_TAG = new Tag(TagClass.UNIVERSAL, false, 16L);
    public static final Tag SET_TAG = new Tag(TagClass.UNIVERSAL, false, 17L);
    private TagClass tagClass;
    private boolean primitive;
    private long tagNum;
    private long tagNumWithClass;
    protected int numOctets = 0;

    public Tag() {
        this(TagClass.UNIVERSAL, true, 0L);
    }

    public Tag(TagClass tagClass, boolean primitive, long tagNum) {
        this.tagClass = tagClass;
        this.primitive = primitive;
        this.tagNum = tagNum;
        this.calculateTagNumWithClass();
    }

    public TagClass getTagClass() {
        return this.tagClass;
    }

    public void setTagClass(TagClass tagClass) {
        this.tagClass = tagClass;
        this.calculateTagNumWithClass();
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    void setPrimitive(boolean primitive) {
        this.primitive = primitive;
        this.calculateTagNumWithClass();
    }

    public long getTagNum() {
        return this.tagNum;
    }

    public void setTagNum(long tagNum) {
        this.tagNum = tagNum;
        this.calculateTagNumWithClass();
    }

    public long getTagNumWithClass() {
        return this.tagNumWithClass;
    }

    public void setTagNumWithClass(long tagNumWithClass) throws TLVException {
        Tag newTag = Tag.fromBER(LongUtils.toByteArray(tagNumWithClass));
        this.tagClass = newTag.tagClass;
        this.primitive = newTag.primitive;
        this.tagNum = newTag.tagNum;
        this.tagNumWithClass = tagNumWithClass;
    }

    private void calculateTagNumWithClass() {
        byte[] rest;
        byte leading = this.tagClass.num;
        leading = (byte)(leading << 1 | (this.primitive ? 0 : 1));
        if (this.tagNum >= 31L) {
            leading = (byte)(leading << 5 | 0x1F);
            rest = LongUtils.toByteArray(this.tagNum, 7);
            int i = 0;
            while (i < rest.length - 1) {
                int n = i++;
                rest[n] = (byte)(rest[n] | 0x80);
            }
        } else {
            leading = (byte)((long)(leading << 5) | this.tagNum);
            rest = new byte[]{};
        }
        byte[] resultBytes = ByteUtils.concatenate(leading, rest);
        this.tagNumWithClass = ByteUtils.toLong(resultBytes);
    }

    public static Tag fromBER(byte[] data) throws TLVException {
        int numOctets = 1;
        TagClass tagClass = TagClass.getTagClass(data[0]);
        boolean primitive = (data[0] >> 5 & 1) == 0;
        long tagNum = 0L;
        byte tmpTagNum = (byte)(data[0] & 0x1F);
        if (tmpTagNum <= 30) {
            tagNum = tmpTagNum;
        } else {
            byte next;
            do {
                if (numOctets * 7 > 64) {
                    throw new TLVException("Tag number doesn't fit into a 64 bit word.");
                }
                if (data.length < numOctets) {
                    throw new TLVException("Not enough bytes in input bytes to build TLV tag.");
                }
                next = data[numOctets];
                ++numOctets;
                byte nextValue = (byte)(next & 0x7F);
                tagNum = tagNum << 7 | (long)nextValue;
            } while ((next >> 7 & 1) == 1);
        }
        Tag resultTag = new Tag(tagClass, primitive, tagNum);
        resultTag.numOctets = numOctets;
        return resultTag;
    }

    public byte[] toBER() {
        return LongUtils.toByteArray(this.tagNumWithClass);
    }

    public String toString() {
        return "[" + this.tagClass.toString() + " " + (this.primitive ? "prim " : "cons ") + this.tagNum + " (0x" + Long.toHexString(this.tagNumWithClass) + ")]";
    }
}

