/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.state;

import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import org.openecard.common.enums.EventType;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.sal.state.HandlePrinter;
import org.openecard.recognition.CardRecognition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SALStateCallback
implements EventCallback {
    private static final Logger logger = LoggerFactory.getLogger(SALStateCallback.class);
    private final CardRecognition recognition;
    private final CardStateMap cardState;

    public SALStateCallback(CardRecognition recognition, CardStateMap cardState) {
        this.recognition = recognition;
        this.cardState = cardState;
    }

    @Override
    public void signalEvent(EventType eventType, Object eventData) {
        if (eventData instanceof ConnectionHandleType) {
            ConnectionHandleType handle = (ConnectionHandleType)eventData;
            switch (eventType) {
                case CARD_RECOGNIZED: {
                    logger.info("Add ConnectionHandle to SAL:\n{}", (Object)HandlePrinter.printHandle(handle));
                    CardInfoType cif = this.recognition.getCardInfo(handle.getRecognitionInfo().getCardType());
                    if (cif != null) {
                        CardStateEntry entry = new CardStateEntry(handle, cif);
                        this.cardState.addEntry(entry);
                        break;
                    }
                    logger.info("Not adding card to SAL, because it has no CardInfo file.");
                    break;
                }
                case CARD_REMOVED: {
                    logger.info("Remove ConnectionHandle from SAL.\n{}", (Object)HandlePrinter.printHandle(handle));
                    this.cardState.removeEntry(handle);
                    break;
                }
            }
        }
    }
}

