/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.httpcore;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.RequestLine;
import org.openecard.apache.http.StatusLine;
import org.slf4j.Logger;

public class HttpUtils {
    public static void dumpHttpRequest(@Nonnull Logger logger, @Nonnull HttpRequest req) {
        HttpUtils.dumpHttpRequest(logger, null, req);
    }

    public static void dumpHttpRequest(@Nonnull Logger logger, @Nullable String msg, @Nonnull HttpRequest req) {
        if (logger.isDebugEnabled()) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            pw.print("HTTP Request");
            if (msg != null) {
                pw.format(" (%s)", msg);
            }
            pw.println(":");
            RequestLine rl = req.getRequestLine();
            pw.format("  %s %s %s%n", rl.getMethod(), rl.getUri(), rl.getProtocolVersion().toString());
            for (Header h : req.getAllHeaders()) {
                pw.format("  %s: %s%n", h.getName(), h.getValue());
            }
            pw.flush();
            logger.debug(w.toString());
        }
    }

    public static void dumpHttpResponse(@Nonnull Logger logger, @Nonnull HttpResponse res, @Nullable byte[] entityData) {
        if (logger.isDebugEnabled()) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            pw.println("HTTP Response:");
            StatusLine sl = res.getStatusLine();
            pw.format("  %s %d %s%n", sl.getProtocolVersion().toString(), sl.getStatusCode(), sl.getReasonPhrase());
            for (Header h : res.getAllHeaders()) {
                pw.format("  %s: %s%n", h.getName(), h.getValue());
            }
            if (entityData != null) {
                pw.format(new String(entityData), new Object[0]);
            }
            pw.println();
            pw.flush();
            logger.debug(w.toString());
        }
    }
}

