/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiUtils {
    private static final Logger logger = LoggerFactory.getLogger(GuiUtils.class);

    public static ImageIcon getImageIcon(String name) {
        URL imageUrl = GuiUtils.class.getResource("images/" + name);
        if (imageUrl == null) {
            imageUrl = GuiUtils.class.getResource("/images/" + name);
        }
        ImageIcon icon = new ImageIcon(imageUrl);
        return icon;
    }

    public static ImageIcon getImageIcon(InputStream imageStream) {
        ImageIcon icon = new ImageIcon();
        try {
            icon = new ImageIcon(ImageIO.read(imageStream));
        }
        catch (IOException ex) {
            logger.error("Failed to read image stream.", ex);
        }
        return icon;
    }

    public static Image getImage(String name) {
        ImageIcon icon = GuiUtils.getImageIcon(name);
        return icon.getImage();
    }
}

