/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class SettingsGroup
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected final Properties properties;
    private final JPanel container;
    private final HashMap<String, Object> inputFields;
    private int itemIdx;

    public SettingsGroup(String title, Properties properties) {
        this.properties = properties;
        this.inputFields = new HashMap();
        TitledBorder frameBorder = new TitledBorder(title);
        frameBorder.setTitleJustification(4);
        frameBorder.setTitlePosition(2);
        frameBorder.setTitleFont(new JLabel().getFont().deriveFont(1));
        this.setBorder(frameBorder);
        this.setLayout(new BorderLayout());
        this.container = new JPanel();
        this.add((Component)this.container, "North");
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 10, 0, 0};
        layout.rowHeights = new int[]{0, 0};
        layout.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        layout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.container.setLayout(layout);
    }

    protected abstract void saveProperties() throws IOException, SecurityException;

    protected Object getInputField(String property) {
        return this.inputFields.get(property);
    }

    protected JTextField addInputItem(@Nonnull String name, @Nullable String description, final @Nonnull String property) {
        this.addLabel(name, description);
        String value = this.properties.getProperty(property);
        value = value == null ? "" : value;
        final JTextField input = new JTextField(value);
        this.inputFields.put(property, input);
        input.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsGroup.this.properties.setProperty(property, input.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsGroup.this.properties.setProperty(property, input.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.addComponent(input);
        ++this.itemIdx;
        return input;
    }

    protected JComboBox<String> addSelectionItem(@Nonnull String name, @Nullable String description, final @Nonnull String property, String ... values) {
        this.addLabel(name, description);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.setModel(new DefaultComboBoxModel<String>(values));
        comboBox.setSelectedItem(this.properties.getProperty(property));
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SettingsGroup.this.properties.setProperty(property, (String)e.getItem());
                }
            }
        });
        this.addComponent(comboBox);
        ++this.itemIdx;
        return comboBox;
    }

    protected void addMultiSelectionItem(@Nonnull String name, @Nullable String description, @Nonnull String property, String ... values) {
        this.addLabel(name, description);
        ++this.itemIdx;
    }

    private void addLabel(@Nonnull String name, @Nullable String description) {
        JLabel label = new JLabel(name);
        label.setToolTipText(description);
        label.setFont(label.getFont().deriveFont(0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 0, 5);
        constraints.gridx = 0;
        constraints.gridy = this.itemIdx;
        this.container.add((Component)label, constraints);
    }

    private void addComponent(@Nonnull Component component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 0, 0, 5);
        constraints.fill = 2;
        constraints.gridx = 2;
        constraints.gridy = this.itemIdx;
        this.container.add(component, constraints);
    }
}

