/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio;

import iso.std.iso_iec._24727.tech.schema.BeginTransaction;
import iso.std.iso_iec._24727.tech.schema.BeginTransactionResponse;
import iso.std.iso_iec._24727.tech.schema.Cancel;
import iso.std.iso_iec._24727.tech.schema.CancelResponse;
import iso.std.iso_iec._24727.tech.schema.ChannelHandleType;
import iso.std.iso_iec._24727.tech.schema.Connect;
import iso.std.iso_iec._24727.tech.schema.ConnectResponse;
import iso.std.iso_iec._24727.tech.schema.ControlIFD;
import iso.std.iso_iec._24727.tech.schema.ControlIFDResponse;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.DestroyChannel;
import iso.std.iso_iec._24727.tech.schema.DestroyChannelResponse;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import iso.std.iso_iec._24727.tech.schema.DisconnectResponse;
import iso.std.iso_iec._24727.tech.schema.DisplayCapabilityType;
import iso.std.iso_iec._24727.tech.schema.EndTransaction;
import iso.std.iso_iec._24727.tech.schema.EndTransactionResponse;
import iso.std.iso_iec._24727.tech.schema.EstablishChannel;
import iso.std.iso_iec._24727.tech.schema.EstablishChannelResponse;
import iso.std.iso_iec._24727.tech.schema.EstablishContext;
import iso.std.iso_iec._24727.tech.schema.EstablishContextResponse;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilities;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilitiesResponse;
import iso.std.iso_iec._24727.tech.schema.GetStatus;
import iso.std.iso_iec._24727.tech.schema.GetStatusResponse;
import iso.std.iso_iec._24727.tech.schema.IFDCapabilitiesType;
import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.KeyPadCapabilityType;
import iso.std.iso_iec._24727.tech.schema.ListIFDs;
import iso.std.iso_iec._24727.tech.schema.ListIFDsResponse;
import iso.std.iso_iec._24727.tech.schema.ModifyVerificationData;
import iso.std.iso_iec._24727.tech.schema.ModifyVerificationDataResponse;
import iso.std.iso_iec._24727.tech.schema.Output;
import iso.std.iso_iec._24727.tech.schema.OutputInfoType;
import iso.std.iso_iec._24727.tech.schema.OutputResponse;
import iso.std.iso_iec._24727.tech.schema.ReleaseContext;
import iso.std.iso_iec._24727.tech.schema.ReleaseContextResponse;
import iso.std.iso_iec._24727.tech.schema.SlotCapabilityType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyUser;
import iso.std.iso_iec._24727.tech.schema.VerifyUserResponse;
import iso.std.iso_iec._24727.tech.schema.Wait;
import iso.std.iso_iec._24727.tech.schema.WaitResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jws.WebService;
import javax.smartcardio.CardException;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.WSHelper;
import org.openecard.common.ifd.PACECapabilities;
import org.openecard.common.ifd.Protocol;
import org.openecard.common.ifd.ProtocolFactory;
import org.openecard.common.ifd.anytype.PACEInputType;
import org.openecard.common.ifd.anytype.PACEOutputType;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.ValueGenerators;
import org.openecard.gui.UserConsent;
import org.openecard.ifd.scio.AbstractTerminal;
import org.openecard.ifd.scio.EventListener;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.IFDUtils;
import org.openecard.ifd.scio.ProtocolFactories;
import org.openecard.ifd.scio.TransmitException;
import org.openecard.ifd.scio.reader.EstablishPACERequest;
import org.openecard.ifd.scio.reader.EstablishPACEResponse;
import org.openecard.ifd.scio.reader.ExecutePACERequest;
import org.openecard.ifd.scio.reader.ExecutePACEResponse;
import org.openecard.ifd.scio.wrapper.SCCard;
import org.openecard.ifd.scio.wrapper.SCChannel;
import org.openecard.ifd.scio.wrapper.SCTerminal;
import org.openecard.ifd.scio.wrapper.SCWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(endpointInterface="org.openecard.ws.IFD")
public class IFD
implements org.openecard.ws.IFD {
    private static final Logger _logger = LoggerFactory.getLogger(IFD.class);
    private byte[] ctxHandle = null;
    private SCWrapper scwrapper;
    private Dispatcher dispatcher;
    private UserConsent gui = null;
    private ProtocolFactories protocolFactories = new ProtocolFactories();
    private AtomicInteger numClients;
    private ExecutorService threadPool;
    private ConcurrentSkipListMap<String, Future<List<IFDStatusType>>> asyncWaitThreads;
    private Future syncWaitThread;

    protected synchronized void removeAsnycTerminal(String session) {
        if (this.asyncWaitThreads != null) {
            this.asyncWaitThreads.remove(session);
        }
    }

    protected Future runThread(Runnable r) {
        return this.threadPool.submit(r);
    }

    protected Future<Void> runCallable(Callable<Void> c) {
        return this.threadPool.submit(c);
    }

    private boolean hasContext() {
        Boolean hasContext = this.ctxHandle != null;
        return hasContext;
    }

    public void setGUI(UserConsent gui) {
        this.gui = gui;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public boolean addProtocol(String proto, ProtocolFactory factory) {
        return this.protocolFactories.add(proto, factory);
    }

    @Override
    public synchronized EstablishContextResponse establishContext(EstablishContext parameters) {
        try {
            if (this.ctxHandle == null) {
                this.scwrapper = new SCWrapper();
                this.ctxHandle = this.scwrapper.createHandle(16);
                this.numClients = new AtomicInteger(1);
                this.threadPool = Executors.newCachedThreadPool();
                this.asyncWaitThreads = new ConcurrentSkipListMap();
            } else {
                this.numClients.incrementAndGet();
            }
            EstablishContextResponse response = (EstablishContextResponse)WSHelper.makeResponse(EstablishContextResponse.class, WSHelper.makeResultOK());
            response.setContextHandle(this.ctxHandle);
            return response;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (EstablishContextResponse)WSHelper.makeResponse(EstablishContextResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public synchronized ReleaseContextResponse releaseContext(ReleaseContext parameters) {
        try {
            if (IFDUtils.arrayEquals(this.ctxHandle, parameters.getContextHandle())) {
                if (this.numClients.decrementAndGet() == 0) {
                    this.ctxHandle = null;
                    this.numClients = null;
                    this.threadPool.shutdownNow();
                    this.threadPool = null;
                    this.asyncWaitThreads = null;
                }
                ReleaseContextResponse response = (ReleaseContextResponse)WSHelper.makeResponse(ReleaseContextResponse.class, WSHelper.makeResultOK());
                return response;
            }
            ReleaseContextResponse response = (ReleaseContextResponse)WSHelper.makeResponse(ReleaseContextResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", "Invalid context handle specified."));
            return response;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (ReleaseContextResponse)WSHelper.makeResponse(ReleaseContextResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public ListIFDsResponse listIFDs(ListIFDs parameters) {
        try {
            if (!IFDUtils.arrayEquals(this.ctxHandle, parameters.getContextHandle())) {
                ListIFDsResponse response = (ListIFDsResponse)WSHelper.makeResponse(ListIFDsResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", "Invalid context handle specified."));
                return response;
            }
            try {
                List<String> ifds = this.scwrapper.getTerminalNames(true);
                ListIFDsResponse response = (ListIFDsResponse)WSHelper.makeResponse(ListIFDsResponse.class, WSHelper.makeResultOK());
                response.getIFDName().addAll(ifds);
                return response;
            }
            catch (IFDException ex) {
                ListIFDsResponse response = (ListIFDsResponse)WSHelper.makeResponse(ListIFDsResponse.class, ex.getResult());
                _logger.warn(ex.getMessage(), ex);
                return response;
            }
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (ListIFDsResponse)WSHelper.makeResponse(ListIFDsResponse.class, WSHelper.makeResult(ex));
        }
    }

    private List<String> buildPACEProtocolList(List<PACECapabilities.PACECapability> paceCapabilities) {
        LinkedList<String> supportedProtos = new LinkedList<String>();
        for (PACECapabilities.PACECapability next : paceCapabilities) {
            supportedProtos.add(next.getProtocol());
        }
        return supportedProtos;
    }

    @Override
    public GetIFDCapabilitiesResponse getIFDCapabilities(GetIFDCapabilities parameters) {
        try {
            if (!IFDUtils.arrayEquals(this.ctxHandle, parameters.getContextHandle())) {
                GetIFDCapabilitiesResponse response = (GetIFDCapabilitiesResponse)WSHelper.makeResponse(GetIFDCapabilitiesResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", "Invalid context handle specified."));
                return response;
            }
            try {
                KeyPadCapabilityType keyCap;
                SCTerminal t = this.scwrapper.getTerminal(parameters.getIFDName(), true);
                IFDCapabilitiesType cap = new IFDCapabilitiesType();
                cap.setAcousticSignalUnit(t.isAcousticSignal());
                cap.setOpticalSignalUnit(t.isOpticalSignal());
                DisplayCapabilityType dispCap = t.getDisplayCapability();
                if (dispCap != null) {
                    cap.getDisplayCapability().add(dispCap);
                }
                if ((keyCap = t.getKeypadCapability()) != null) {
                    cap.getKeyPadCapability().add(keyCap);
                }
                SlotCapabilityType slotCap = new SlotCapabilityType();
                slotCap.setIndex(BigInteger.ZERO);
                cap.getSlotCapability().add(slotCap);
                if (this.gui != null && t.supportsPace()) {
                    List<PACECapabilities.PACECapability> capabilities = t.getPACECapabilities();
                    List<String> protos = this.buildPACEProtocolList(capabilities);
                    slotCap.getProtocol().addAll(protos);
                }
                if (this.gui != null) {
                    slotCap.getProtocol().add("urn:oid:1.3.162.15480.3.0.9");
                } else if (t.supportsPinCompare()) {
                    slotCap.getProtocol().add("urn:oid:1.3.162.15480.3.0.9");
                }
                for (String proto : this.protocolFactories.protocols()) {
                    if (slotCap.getProtocol().contains(proto)) continue;
                    slotCap.getProtocol().add(proto);
                }
                GetIFDCapabilitiesResponse response = (GetIFDCapabilitiesResponse)WSHelper.makeResponse(GetIFDCapabilitiesResponse.class, WSHelper.makeResultOK());
                response.setIFDCapabilities(cap);
                return response;
            }
            catch (IFDException ex) {
                GetIFDCapabilitiesResponse response = (GetIFDCapabilitiesResponse)WSHelper.makeResponse(GetIFDCapabilitiesResponse.class, ex.getResult());
                _logger.warn(ex.getMessage(), ex);
                return response;
            }
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (GetIFDCapabilitiesResponse)WSHelper.makeResponse(GetIFDCapabilitiesResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public GetStatusResponse getStatus(GetStatus parameters) {
        try {
            if (!IFDUtils.arrayEquals(this.ctxHandle, parameters.getContextHandle())) {
                GetStatusResponse response = (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", "Invalid context handle specified."));
                return response;
            }
            LinkedList<SCTerminal> ifds = new LinkedList<SCTerminal>();
            try {
                if (parameters.getIFDName() != null) {
                    SCTerminal t = this.scwrapper.getTerminal(parameters.getIFDName(), true);
                    if (t == null) {
                        GetStatusResponse response = (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, WSHelper.makeResult("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error", "http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownIFD", "Unknown IFD."));
                        return response;
                    }
                    ifds.add(t);
                } else {
                    ifds.addAll(this.scwrapper.getTerminals(true));
                }
            }
            catch (IFDException ex) {
                GetStatusResponse response = (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, ex.getResult());
                _logger.warn(ex.getMessage(), ex);
                return response;
            }
            ArrayList<IFDStatusType> statuss = new ArrayList<IFDStatusType>(ifds.size());
            for (SCTerminal ifd : ifds) {
                try {
                    IFDStatusType s = ifd.getStatus();
                    statuss.add(s);
                }
                catch (IFDException ex) {
                    GetStatusResponse response = (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, ex.getResult());
                    _logger.warn(ex.getMessage(), ex);
                    return response;
                }
            }
            GetStatusResponse response = (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, WSHelper.makeResultOK());
            response.getIFDStatus().addAll(statuss);
            return response;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (GetStatusResponse)WSHelper.makeResponse(GetStatusResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public WaitResponse wait(Wait parameters) {
        try {
            ChannelHandleType callback;
            if (!IFDUtils.arrayEquals(this.ctxHandle, parameters.getContextHandle())) {
                WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", "Invalid context handle specified."));
                return response;
            }
            BigInteger timeout = parameters.getTimeOut();
            if (timeout == null) {
                timeout = BigInteger.valueOf(Long.MAX_VALUE);
            }
            if ((callback = parameters.getCallback()) != null && callback.getProtocolTerminationPoint() == null) {
                callback = null;
            }
            List<IFDStatusType> expectedStatuses = parameters.getIFDStatus();
            boolean withNew = false;
            if (expectedStatuses.isEmpty()) {
                withNew = true;
                GetStatus statusReq = new GetStatus();
                statusReq.setContextHandle(this.ctxHandle);
                GetStatusResponse status = this.getStatus(statusReq);
                if (status.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                    WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, status.getResult());
                    return response;
                }
                expectedStatuses = status.getIFDStatus();
            } else {
                for (IFDStatusType s : expectedStatuses) {
                    if (s.getIFDName() != null) continue;
                    WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/terminal#unknownIFD", "IFD in a request IFDStatus not known."));
                    return response;
                }
            }
            if (callback != null) {
                ChannelHandleType newCallback = new ChannelHandleType();
                newCallback.setBinding(callback.getBinding());
                newCallback.setPathSecurity(callback.getPathSecurity());
                newCallback.setProtocolTerminationPoint(callback.getProtocolTerminationPoint());
                newCallback.setSessionIdentifier(ValueGenerators.generateSessionID());
                callback = newCallback;
            }
            EventListener l = new EventListener(this, this.scwrapper, this.ctxHandle, timeout.longValue(), callback, expectedStatuses, withNew);
            FutureTask<List<IFDStatusType>> future = new FutureTask<List<IFDStatusType>>(l);
            if (l.isAsync()) {
                this.asyncWaitThreads.put(callback.getSessionIdentifier(), future);
                this.threadPool.execute(future);
                WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, WSHelper.makeResultOK());
                if (callback.getSessionIdentifier() != null) {
                    response.setSessionIdentifier(callback.getSessionIdentifier());
                }
                return response;
            }
            this.syncWaitThread = future;
            this.threadPool.execute(future);
            List<IFDStatusType> events = future.get();
            WaitResponse response = (WaitResponse)WSHelper.makeResponse(WaitResponse.class, WSHelper.makeResultOK());
            response.getIFDEvent().addAll(events);
            return response;
        }
        catch (ExecutionException ex) {
            _logger.warn(ex.getMessage(), ex);
            return (WaitResponse)WSHelper.makeResponse(WaitResponse.class, WSHelper.makeResult(ex.getCause()));
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (WaitResponse)WSHelper.makeResponse(WaitResponse.class, WSHelper.makeResult(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelResponse cancel(Cancel parameters) {
        try {
            CancelResponse response = null;
            if (!IFDUtils.arrayEquals(this.ctxHandle, parameters.getContextHandle())) {
                response = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", "Invalid context handle specified."));
            } else if (parameters.getSessionIdentifier() != null) {
                String session = parameters.getSessionIdentifier();
                Future<List<IFDStatusType>> f = this.asyncWaitThreads.get(session);
                if (f != null) {
                    f.cancel(true);
                    response = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, WSHelper.makeResultOK());
                }
            } else {
                IFD iFD = this;
                synchronized (iFD) {
                    if (this.syncWaitThread != null) {
                        this.syncWaitThread.cancel(true);
                        this.syncWaitThread = null;
                        response = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, WSHelper.makeResultOK());
                    } else {
                        response = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#cancelNotPossible", "No synchronous Wait to cancel."));
                    }
                }
            }
            if (response == null) {
                response = (CancelResponse)WSHelper.makeResponse(CancelResponse.class, WSHelper.makeResultUnknownError("No cancelable command matches the given parameters."));
            }
            return response;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (CancelResponse)WSHelper.makeResponse(CancelResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public ControlIFDResponse controlIFD(ControlIFD parameters) {
        try {
            if (!IFDUtils.arrayEquals(this.ctxHandle, parameters.getContextHandle())) {
                ControlIFDResponse response = (ControlIFDResponse)WSHelper.makeResponse(ControlIFDResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", "Invalid context handle specified."));
                return response;
            }
            try {
                SCTerminal t = this.scwrapper.getTerminal(parameters.getIFDName());
                byte[] command = parameters.getCommand();
                byte ctrlCode = command[0];
                command = Arrays.copyOfRange(command, 1, command.length);
                byte[] resultCommand = t.executeCtrlCode(ctrlCode, command);
                ControlIFDResponse response = (ControlIFDResponse)WSHelper.makeResponse(ControlIFDResponse.class, WSHelper.makeResultOK());
                response.setResponse(resultCommand);
                return response;
            }
            catch (IFDException ex) {
                ControlIFDResponse response = (ControlIFDResponse)WSHelper.makeResponse(ControlIFDResponse.class, WSHelper.makeResult(ex));
                return response;
            }
        }
        catch (Throwable ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (ControlIFDResponse)WSHelper.makeResponse(ControlIFDResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public ConnectResponse connect(Connect parameters) {
        try {
            if (!IFDUtils.arrayEquals(this.ctxHandle, parameters.getContextHandle())) {
                ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", "Invalid context handle specified."));
                return response;
            }
            try {
                if (!IFDUtils.getSlotIndex(parameters.getIFDName()).equals(parameters.getSlot())) {
                    ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Invalid slot handle."));
                    return response;
                }
                SCTerminal t = this.scwrapper.getTerminal(parameters.getIFDName());
                SCChannel channel = t.connect();
                Boolean exclusive = parameters.isExclusive();
                if (exclusive != null && exclusive.booleanValue()) {
                    BeginTransaction transact = new BeginTransaction();
                    transact.setSlotHandle(channel.getHandle());
                    BeginTransactionResponse resp = this.beginTransaction(transact);
                    if (resp.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                        ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, resp.getResult());
                        return response;
                    }
                }
                ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, WSHelper.makeResultOK());
                response.setSlotHandle(channel.getHandle());
                return response;
            }
            catch (IFDException ex) {
                ConnectResponse response = (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, ex.getResult());
                _logger.warn(ex.getMessage(), ex);
                return response;
            }
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (ConnectResponse)WSHelper.makeResponse(ConnectResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public synchronized DisconnectResponse disconnect(Disconnect parameters) {
        try {
            if (!this.hasContext()) {
                DisconnectResponse response = (DisconnectResponse)WSHelper.makeResponse(DisconnectResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Context not initialized."));
                return response;
            }
            byte[] handle = parameters.getSlotHandle();
            try {
                SCCard c = this.scwrapper.getCard(handle);
                c.closeChannel(handle, false);
                DisconnectResponse response = (DisconnectResponse)WSHelper.makeResponse(DisconnectResponse.class, WSHelper.makeResultOK());
                return response;
            }
            catch (IFDException ex) {
                DisconnectResponse response = (DisconnectResponse)WSHelper.makeResponse(DisconnectResponse.class, ex.getResult());
                _logger.warn(ex.getMessage(), ex);
                return response;
            }
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (DisconnectResponse)WSHelper.makeResponse(DisconnectResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public BeginTransactionResponse beginTransaction(BeginTransaction beginTransaction) {
        try {
            if (!this.hasContext()) {
                BeginTransactionResponse response = (BeginTransactionResponse)WSHelper.makeResponse(BeginTransactionResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Context not initialized."));
                return response;
            }
            byte[] handle = beginTransaction.getSlotHandle();
            try {
                SCCard c = this.scwrapper.getCard(handle);
                c.beginExclusive();
                BeginTransactionResponse response = (BeginTransactionResponse)WSHelper.makeResponse(BeginTransactionResponse.class, WSHelper.makeResultOK());
                return response;
            }
            catch (CardException ex) {
                BeginTransactionResponse response = (BeginTransactionResponse)WSHelper.makeResponse(BeginTransactionResponse.class, WSHelper.makeResult(ex));
                _logger.warn(ex.getMessage(), ex);
                return response;
            }
            catch (IFDException ex) {
                BeginTransactionResponse response = (BeginTransactionResponse)WSHelper.makeResponse(BeginTransactionResponse.class, ex.getResult());
                _logger.warn(ex.getMessage(), ex);
                return response;
            }
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (BeginTransactionResponse)WSHelper.makeResponse(BeginTransactionResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public EndTransactionResponse endTransaction(EndTransaction parameters) {
        try {
            if (!this.hasContext()) {
                EndTransactionResponse response = (EndTransactionResponse)WSHelper.makeResponse(EndTransactionResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Context not initialized."));
                return response;
            }
            byte[] handle = parameters.getSlotHandle();
            try {
                SCCard c = this.scwrapper.getCard(handle);
                c.endExclusive();
                EndTransactionResponse response = (EndTransactionResponse)WSHelper.makeResponse(EndTransactionResponse.class, WSHelper.makeResultOK());
                return response;
            }
            catch (CardException ex) {
                EndTransactionResponse response = (EndTransactionResponse)WSHelper.makeResponse(EndTransactionResponse.class, WSHelper.makeResult(ex));
                _logger.warn(ex.getMessage(), ex);
                return response;
            }
            catch (IFDException ex) {
                EndTransactionResponse response = (EndTransactionResponse)WSHelper.makeResponse(EndTransactionResponse.class, ex.getResult());
                _logger.warn(ex.getMessage(), ex);
                return response;
            }
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (EndTransactionResponse)WSHelper.makeResponse(EndTransactionResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public TransmitResponse transmit(Transmit parameters) {
        try {
            Result result;
            if (!this.hasContext()) {
                TransmitResponse response = (TransmitResponse)WSHelper.makeResponse(TransmitResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Context not initialized."));
                return response;
            }
            byte[] handle = parameters.getSlotHandle();
            List<InputAPDUInfoType> apdus = parameters.getInputAPDUInfo();
            TransmitResponse response = (TransmitResponse)WSHelper.makeResponse(TransmitResponse.class, null);
            List<byte[]> rapdus = response.getOutputAPDU();
            try {
                SCChannel ch = this.scwrapper.getChannel(handle);
                for (InputAPDUInfoType capdu : apdus) {
                    byte[] rapdu = ch.transmit(capdu.getInputAPDU(), capdu.getAcceptableStatusCode());
                    rapdus.add(rapdu);
                }
                result = WSHelper.makeResultOK();
            }
            catch (TransmitException ex) {
                rapdus.add(ex.getResponseAPDU());
                result = ex.getResult();
            }
            catch (IFDException ex) {
                result = ex.getResult();
            }
            response.setResult(result);
            return response;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (TransmitResponse)WSHelper.makeResponse(TransmitResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public VerifyUserResponse verifyUser(VerifyUser parameters) {
        try {
            if (!this.hasContext()) {
                VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Context not initialized."));
                return response;
            }
            AbstractTerminal aTerm = new AbstractTerminal(this, this.scwrapper, this.gui, this.ctxHandle, parameters.getDisplayIndex());
            try {
                VerifyUserResponse response = aTerm.verifyUser(parameters);
                return response;
            }
            catch (IFDException ex) {
                VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, ex.getResult());
                return response;
            }
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public ModifyVerificationDataResponse modifyVerificationData(ModifyVerificationData parameters) {
        try {
            if (!this.hasContext()) {
                return (ModifyVerificationDataResponse)WSHelper.makeResponse(ModifyVerificationDataResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle", "Context not initialized."));
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (ModifyVerificationDataResponse)WSHelper.makeResponse(ModifyVerificationDataResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public OutputResponse output(Output parameters) {
        try {
            if (!IFDUtils.arrayEquals(this.ctxHandle, parameters.getContextHandle())) {
                OutputResponse response = (OutputResponse)WSHelper.makeResponse(OutputResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidContextHandle", "Invalid context handle specified."));
                return response;
            }
            String ifdName = parameters.getIFDName();
            OutputInfoType outInfo = parameters.getOutputInfo();
            AbstractTerminal aTerm = new AbstractTerminal(this, this.scwrapper, this.gui, this.ctxHandle, outInfo.getDisplayIndex());
            try {
                aTerm.output(ifdName, outInfo);
            }
            catch (IFDException ex) {
                OutputResponse response = (OutputResponse)WSHelper.makeResponse(OutputResponse.class, ex.getResult());
                return response;
            }
            OutputResponse response = (OutputResponse)WSHelper.makeResponse(OutputResponse.class, WSHelper.makeResultOK());
            return response;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            _logger.warn(ex.getMessage(), ex);
            return (OutputResponse)WSHelper.makeResponse(OutputResponse.class, WSHelper.makeResult(ex));
        }
    }

    @Override
    public EstablishChannelResponse establishChannel(EstablishChannel parameters) {
        byte[] slotHandle = parameters.getSlotHandle();
        try {
            SCTerminal term = this.scwrapper.getTerminal(slotHandle);
            SCCard card = this.scwrapper.getCard(slotHandle);
            SCChannel channel = card.getChannel(slotHandle);
            DIDAuthenticationDataType protoParam = parameters.getAuthenticationProtocolData();
            String protocol = protoParam.getProtocol();
            List<PACECapabilities.PACECapability> paceCapabilities = term.getPACECapabilities();
            List<String> supportedProtos = this.buildPACEProtocolList(paceCapabilities);
            if (!supportedProtos.isEmpty() && supportedProtos.get(0).startsWith(protocol)) {
                PACEInputType paceParam = new PACEInputType(protoParam);
                byte pinID = paceParam.getPINID();
                byte[] chat = paceParam.getCHAT();
                String pin = paceParam.getPIN();
                byte[] certDesc = paceParam.getCertificateDescription();
                EstablishPACERequest estPaceReq = new EstablishPACERequest(pinID, chat, null, certDesc);
                ExecutePACERequest execPaceReq = new ExecutePACERequest(ExecutePACERequest.Function.EstablishPACEChannel, estPaceReq.toBytes());
                if (estPaceReq.isSupportedType(paceCapabilities)) {
                    byte[] reqData = execPaceReq.toBytes();
                    byte[] resData = term.executeCtrlCode(32, reqData);
                    ExecutePACEResponse execPaceRes = new ExecutePACEResponse(resData);
                    if (execPaceRes.isError()) {
                        return (EstablishChannelResponse)WSHelper.makeResponse(EstablishChannelResponse.class, execPaceRes.getResult());
                    }
                    EstablishPACEResponse estPaceRes = new EstablishPACEResponse(execPaceRes.getData());
                    PACEOutputType authDataResponse = paceParam.getOutputType();
                    authDataResponse.setRetryCounter(estPaceRes.getRetryCounter());
                    authDataResponse.setEFCardAccess(estPaceRes.getEFCardAccess());
                    if (estPaceRes.hasCurrentCAR()) {
                        authDataResponse.setCurrentCAR(estPaceRes.getCurrentCAR());
                    }
                    if (estPaceRes.hasPreviousCAR()) {
                        authDataResponse.setPreviousCAR(estPaceRes.getPreviousCAR());
                    }
                    if (estPaceRes.hasIDICC()) {
                        authDataResponse.setIDPICC(estPaceRes.getIDICC());
                    }
                    EstablishChannelResponse response = (EstablishChannelResponse)WSHelper.makeResponse(EstablishChannelResponse.class, WSHelper.makeResultOK());
                    response.setAuthenticationProtocolData(authDataResponse.getAuthDataType());
                    return response;
                }
            }
            if (this.protocolFactories.contains(protocol)) {
                ProtocolFactory factory = this.protocolFactories.get(protocol);
                Protocol protoImpl = factory.createInstance();
                EstablishChannelResponse response = protoImpl.establish(parameters, this.dispatcher, this.gui);
                if (response.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok")) {
                    channel.addSecureMessaging(protoImpl);
                }
                return response;
            }
            return (EstablishChannelResponse)WSHelper.makeResponse(EstablishChannelResponse.class, WSHelper.makeResultUnknownError("No such protocol available in this IFD."));
        }
        catch (Throwable t) {
            return (EstablishChannelResponse)WSHelper.makeResponse(EstablishChannelResponse.class, WSHelper.makeResult(t));
        }
    }

    @Override
    public DestroyChannelResponse destroyChannel(DestroyChannel parameters) {
        try {
            byte[] slotHandle = parameters.getSlotHandle();
            SCCard card = this.scwrapper.getCard(slotHandle);
            SCChannel channel = card.getChannel(slotHandle);
            channel.removeSecureMessaging();
            DestroyChannelResponse destroyChannelResponse = new DestroyChannelResponse();
            Result r = new Result();
            r.setResultMajor("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok");
            destroyChannelResponse.setResult(r);
            return destroyChannelResponse;
        }
        catch (Throwable t) {
            return (DestroyChannelResponse)WSHelper.makeResponse(DestroyChannelResponse.class, WSHelper.makeResult(t));
        }
    }
}

