/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import java.security.spec.AlgorithmParameterSpec;
import org.openecard.crypto.common.asn1.eac.ExplicitDomainParameters;
import org.openecard.crypto.common.asn1.eac.PACEDomainParameterInfo;
import org.openecard.crypto.common.asn1.eac.PACEInfo;
import org.openecard.crypto.common.asn1.eac.PACESecurityInfos;
import org.openecard.crypto.common.asn1.eac.StandardizedDomainParameters;

public final class PACEDomainParameter {
    private AlgorithmParameterSpec domainParameter;
    private PACESecurityInfos psi;
    private PACEInfo pi;

    public PACEDomainParameter(PACESecurityInfos psi) {
        this.psi = psi;
        this.pi = psi.getPACEInfo();
        this.loadParameters();
    }

    public PACEDomainParameter(PACESecurityInfos psi, AlgorithmParameterSpec domainParameter) {
        this.psi = psi;
        this.pi = psi.getPACEInfo();
        this.domainParameter = domainParameter;
    }

    public AlgorithmParameterSpec getParameter() {
        return this.domainParameter;
    }

    public void setParameter(AlgorithmParameterSpec domainParameter) {
        this.domainParameter = domainParameter;
    }

    public boolean isDH() {
        return this.pi.isDH();
    }

    public boolean isECDH() {
        return this.pi.isECDH();
    }

    private void loadParameters() {
        if (this.pi.getParameterID() != -1) {
            int index = this.pi.getParameterID();
            this.domainParameter = new StandardizedDomainParameters(index).getParameter();
        } else {
            PACEDomainParameterInfo pdp = this.psi.getPACEDomainParameterInfo();
            this.domainParameter = new ExplicitDomainParameters(pdp.getDomainParameter()).getParameter();
        }
        if (this.domainParameter == null) {
            throw new IllegalArgumentException("Cannot load domain parameter");
        }
    }
}

