/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu;

import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.ShortUtils;

public class UpdateRecord
extends CardCommandAPDU {
    private static final byte UPDATE_RECORD_INS_1 = -36;
    private static final byte UPDATE_RECORD_INS_2 = -35;

    public UpdateRecord(byte[] updatingData) {
        super((byte)0, (byte)-36, (byte)1, (byte)4);
        this.setData(updatingData);
    }

    public UpdateRecord(byte recordNumber, byte[] updatingData) {
        super((byte)0, (byte)-36, recordNumber, (byte)4);
        this.setData(updatingData);
    }

    public UpdateRecord(byte shortFileID, byte recordNumber, byte[] updatingData) {
        super((byte)0, (byte)-36, recordNumber, (byte)(shortFileID << 3 | 4));
        this.setData(updatingData);
    }

    public UpdateRecord(byte recordNumber, short offset, byte[] updatingData) {
        super((byte)0, (byte)-35, recordNumber, (byte)4);
        byte[] offsetDataObject = ShortUtils.toByteArray(offset);
        offsetDataObject = ByteUtils.concatenate((byte)84, offsetDataObject);
        byte[] updatingDataObject = ByteUtils.concatenate((byte)83, updatingData);
        byte[] content = ByteUtils.concatenate(offsetDataObject, updatingDataObject);
        this.setData(content);
    }

    public UpdateRecord(byte shortFileID, byte recordNumber, short offset, byte[] updatingData) {
        super((byte)0, (byte)-35, recordNumber, (byte)(shortFileID << 3 | 4));
        byte[] offsetDataObject = ShortUtils.toByteArray(offset);
        offsetDataObject = ByteUtils.concatenate((byte)84, offsetDataObject);
        byte[] updatingDataObject = ByteUtils.concatenate((byte)83, updatingData);
        byte[] content = ByteUtils.concatenate(offsetDataObject, updatingDataObject);
        this.setData(content);
    }
}

