/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.asn1.ua;

import java.math.BigInteger;
import java.util.Random;
import org.openecard.bouncycastle.asn1.x9.X9IntegerConverter;
import org.openecard.bouncycastle.math.ec.ECConstants;
import org.openecard.bouncycastle.math.ec.ECCurve;
import org.openecard.bouncycastle.math.ec.ECFieldElement;
import org.openecard.bouncycastle.math.ec.ECPoint;
import org.openecard.bouncycastle.util.Arrays;

public abstract class DSTU4145PointEncoder {
    private static X9IntegerConverter converter = new X9IntegerConverter();

    private static BigInteger trace(ECFieldElement fe) {
        ECFieldElement t = fe;
        for (int i = 0; i < fe.getFieldSize() - 1; ++i) {
            t = t.square().add(fe);
        }
        return t.toBigInteger();
    }

    private static ECFieldElement solveQuadradicEquation(ECFieldElement beta) {
        ECFieldElement.F2m b = (ECFieldElement.F2m)beta;
        ECFieldElement.F2m zeroElement = new ECFieldElement.F2m(b.getM(), b.getK1(), b.getK2(), b.getK3(), ECConstants.ZERO);
        if (beta.toBigInteger().equals(ECConstants.ZERO)) {
            return zeroElement;
        }
        ECFieldElement z = null;
        ECFieldElement gamma = zeroElement;
        Random rand = new Random();
        int m = b.getM();
        do {
            ECFieldElement.F2m t = new ECFieldElement.F2m(b.getM(), b.getK1(), b.getK2(), b.getK3(), new BigInteger(m, rand));
            z = zeroElement;
            ECFieldElement w = beta;
            for (int i = 1; i <= m - 1; ++i) {
                ECFieldElement w2 = w.square();
                z = ((ECFieldElement)z).square().add(w2.multiply(t));
                w = w2.add(beta);
            }
            if (w.toBigInteger().equals(ECConstants.ZERO)) continue;
            return null;
        } while ((gamma = ((ECFieldElement)z).square().add(z)).toBigInteger().equals(ECConstants.ZERO));
        return z;
    }

    public static byte[] encodePoint(ECPoint Q) {
        int byteCount = converter.getByteLength(Q.getX());
        byte[] bytes = converter.integerToBytes(Q.getX().toBigInteger(), byteCount);
        if (!Q.getX().toBigInteger().equals(ECConstants.ZERO)) {
            ECFieldElement y = Q.getY().multiply(Q.getX().invert());
            if (DSTU4145PointEncoder.trace(y).equals(ECConstants.ONE)) {
                int n = bytes.length - 1;
                bytes[n] = (byte)(bytes[n] | 1);
            } else {
                int n = bytes.length - 1;
                bytes[n] = (byte)(bytes[n] & 0xFE);
            }
        }
        return bytes;
    }

    public static ECPoint decodePoint(ECCurve curve, byte[] bytes) {
        BigInteger k = BigInteger.valueOf(bytes[bytes.length - 1] & 1);
        if (!DSTU4145PointEncoder.trace(curve.fromBigInteger(new BigInteger(1, bytes))).equals(curve.getA().toBigInteger())) {
            bytes = Arrays.clone(bytes);
            int n = bytes.length - 1;
            bytes[n] = (byte)(bytes[n] ^ 1);
        }
        ECCurve.F2m c = (ECCurve.F2m)curve;
        ECFieldElement xp = curve.fromBigInteger(new BigInteger(1, bytes));
        ECFieldElement yp = null;
        if (xp.toBigInteger().equals(ECConstants.ZERO)) {
            yp = (ECFieldElement.F2m)curve.getB();
            for (int i = 0; i < c.getM() - 1; ++i) {
                yp = ((ECFieldElement)yp).square();
            }
        } else {
            ECFieldElement beta = xp.add(curve.getA()).add(curve.getB().multiply(xp.square().invert()));
            ECFieldElement z = DSTU4145PointEncoder.solveQuadradicEquation(beta);
            if (z == null) {
                throw new RuntimeException("Invalid point compression");
            }
            if (!DSTU4145PointEncoder.trace(z).equals(k)) {
                z = z.add(curve.fromBigInteger(ECConstants.ONE));
            }
            yp = xp.multiply(z);
        }
        return new ECPoint.F2m(curve, xp, yp);
    }
}

