/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio.osx;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import org.openecard.scio.osx.PCSC;
import org.openecard.scio.osx.PCSCException;
import org.openecard.scio.osx.TerminalImpl;

final class PCSCTerminals
extends CardTerminals {
    private static long contextId;
    private Map<String, ReaderState> stateMap;
    private static final Map<String, Reference<TerminalImpl>> terminals;

    PCSCTerminals() {
    }

    static synchronized void initContext() throws PCSCException {
        if (contextId == 0L) {
            contextId = PCSC.SCardEstablishContext(0);
        }
    }

    private static synchronized TerminalImpl implGetTerminal(String name) {
        TerminalImpl terminal;
        Reference<TerminalImpl> ref = terminals.get(name);
        TerminalImpl terminalImpl = terminal = ref != null ? ref.get() : null;
        if (terminal != null) {
            return terminal;
        }
        terminal = new TerminalImpl(contextId, name);
        terminals.put(name, new WeakReference<TerminalImpl>(terminal));
        return terminal;
    }

    @Override
    public synchronized List<CardTerminal> list(CardTerminals.State state) throws CardException {
        if (state == null) {
            throw new NullPointerException();
        }
        try {
            String[] readerNames = PCSC.SCardListReaders(contextId);
            ArrayList<TerminalImpl> list = new ArrayList<TerminalImpl>(readerNames.length);
            if (this.stateMap == null) {
                if (state == CardTerminals.State.CARD_INSERTION) {
                    state = CardTerminals.State.CARD_PRESENT;
                } else if (state == CardTerminals.State.CARD_REMOVAL) {
                    state = CardTerminals.State.CARD_ABSENT;
                }
            }
            block9: for (String readerName : readerNames) {
                TerminalImpl terminal = PCSCTerminals.implGetTerminal(readerName);
                switch (state) {
                    case ALL: {
                        list.add(terminal);
                        continue block9;
                    }
                    case CARD_PRESENT: {
                        if (!((CardTerminal)terminal).isCardPresent()) continue block9;
                        list.add(terminal);
                        continue block9;
                    }
                    case CARD_ABSENT: {
                        if (((CardTerminal)terminal).isCardPresent()) continue block9;
                        list.add(terminal);
                        continue block9;
                    }
                    case CARD_INSERTION: {
                        ReaderState readerState = this.stateMap.get(readerName);
                        if (readerState == null || !readerState.isInsertion()) continue block9;
                        list.add(terminal);
                        continue block9;
                    }
                    case CARD_REMOVAL: {
                        ReaderState readerState = this.stateMap.get(readerName);
                        if (readerState == null || !readerState.isRemoval()) continue block9;
                        list.add(terminal);
                        continue block9;
                    }
                    default: {
                        throw new CardException("Unknown state: " + (Object)((Object)state));
                    }
                }
            }
            return Collections.unmodifiableList(list);
        }
        catch (PCSCException e) {
            throw new CardException("list() failed", e);
        }
    }

    @Override
    public synchronized boolean waitForChange(long timeout) throws CardException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative: " + timeout);
        }
        if (this.stateMap == null) {
            this.stateMap = new HashMap<String, ReaderState>();
            this.waitForChange(0L);
        }
        if (timeout == 0L) {
            timeout = -1L;
        }
        try {
            int i;
            String[] readerNames = PCSC.SCardListReaders(contextId);
            int n = readerNames.length;
            if (n == 0) {
                throw new IllegalStateException("No terminals available");
            }
            int[] status = new int[n];
            ReaderState[] readerStates = new ReaderState[n];
            for (i = 0; i < readerNames.length; ++i) {
                String name = readerNames[i];
                ReaderState state = this.stateMap.get(name);
                if (state == null) {
                    state = new ReaderState();
                }
                readerStates[i] = state;
                status[i] = state.get();
            }
            status = PCSC.SCardGetStatusChange(contextId, timeout, status, readerNames);
            this.stateMap.clear();
            for (i = 0; i < n; ++i) {
                ReaderState state = readerStates[i];
                state.update(status[i]);
                this.stateMap.put(readerNames[i], state);
            }
            return true;
        }
        catch (PCSCException e) {
            if (e.code == -2146435062) {
                return false;
            }
            throw new CardException("waitForChange() failed", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    static List<CardTerminal> waitForCards(List<? extends CardTerminal> terminals, long timeout, boolean wantPresent) throws CardException {
        long thisTimeout;
        if (timeout == 0L) {
            timeout = -1L;
            thisTimeout = -1L;
        } else {
            thisTimeout = 0L;
        }
        String[] names = new String[terminals.size()];
        int i = 0;
        for (CardTerminal cardTerminal : terminals) {
            if (!(cardTerminal instanceof TerminalImpl)) {
                throw new IllegalArgumentException("Invalid terminal type: " + cardTerminal.getClass().getName());
            }
            TerminalImpl impl = (TerminalImpl)cardTerminal;
            names[i++] = impl.name;
        }
        int[] status = new int[names.length];
        Arrays.fill(status, 0);
        try {
            void var9_10;
            do {
                status = PCSC.SCardGetStatusChange(contextId, thisTimeout, status, names);
                thisTimeout = timeout;
                Object var9_9 = null;
                for (i = 0; i < names.length; ++i) {
                    boolean nowPresent;
                    boolean bl = nowPresent = (status[i] & 0x20) != 0;
                    if (nowPresent != wantPresent) continue;
                    if (var9_10 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var9_10.add(PCSCTerminals.implGetTerminal(names[i]));
                }
            } while (var9_10 == null);
            return Collections.unmodifiableList(var9_10);
        }
        catch (PCSCException pCSCException) {
            if (pCSCException.code == -2146435062) {
                return Collections.emptyList();
            }
            throw new CardException("waitForCard() failed", pCSCException);
        }
    }

    static {
        terminals = new HashMap<String, Reference<TerminalImpl>>();
    }

    private static class ReaderState {
        private int current = 0;
        private int previous = 0;

        ReaderState() {
        }

        int get() {
            return this.current;
        }

        void update(int newState) {
            this.previous = this.current;
            this.current = newState;
        }

        boolean isInsertion() {
            return !ReaderState.present(this.previous) && ReaderState.present(this.current);
        }

        boolean isRemoval() {
            return ReaderState.present(this.previous) && !ReaderState.present(this.current);
        }

        static boolean present(int state) {
            return (state & 0x20) != 0;
        }
    }
}

