/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.state.cif;

import iso.std.iso_iec._24727.tech.schema.AccessControlListType;
import iso.std.iso_iec._24727.tech.schema.AccessRuleType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import iso.std.iso_iec._24727.tech.schema.DataSetInfoType;
import iso.std.iso_iec._24727.tech.schema.DataSetNameListType;
import iso.std.iso_iec._24727.tech.schema.SecurityConditionType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openecard.common.sal.state.cif.DIDInfoWrapper;
import org.openecard.common.sal.state.cif.DataSetInfoWrapper;

public class CardApplicationWrapper {
    private Map<Enum<?>, SecurityConditionType> securityConditions = new HashMap();
    private HashMap<String, DIDInfoWrapper> didInfos = new HashMap();
    private final CardApplicationType cardApplication;
    private DataSetNameListType dataSetNameList = new DataSetNameListType();
    private HashMap<String, DataSetInfoWrapper> dataSetInfos = new HashMap();

    public CardApplicationWrapper(CardApplicationType cardApplication) {
        this.cardApplication = cardApplication;
    }

    public SecurityConditionType getSecurityCondition(Enum<?> serviceAction) {
        if (this.securityConditions.isEmpty()) {
            for (AccessRuleType accessRule : this.cardApplication.getCardApplicationACL().getAccessRule()) {
                if (accessRule.getAction().getConnectionServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getConnectionServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getAuthorizationServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getAuthorizationServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getDifferentialIdentityServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getDifferentialIdentityServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getNamedDataServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getNamedDataServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getCryptographicServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getCryptographicServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getCardApplicationServiceAction() == null) continue;
                this.securityConditions.put(accessRule.getAction().getCardApplicationServiceAction(), accessRule.getSecurityCondition());
            }
        }
        return this.securityConditions.get(serviceAction);
    }

    public byte[] getApplicationIdentifier() {
        return this.cardApplication.getApplicationIdentifier();
    }

    public DIDInfoWrapper getDIDInfo(String didName) {
        if (this.didInfos.isEmpty()) {
            for (DIDInfoType didInfo : this.cardApplication.getDIDInfo()) {
                this.didInfos.put(didInfo.getDifferentialIdentity().getDIDName(), new DIDInfoWrapper(didInfo));
            }
        }
        return this.didInfos.get(didName);
    }

    public List<DIDInfoType> getDIDInfoList() {
        return Collections.unmodifiableList(this.cardApplication.getDIDInfo());
    }

    public AccessControlListType getCardApplicationACL() {
        return this.cardApplication.getCardApplicationACL();
    }

    public DataSetNameListType getDataSetNameList() {
        if (this.dataSetNameList.getDataSetName().isEmpty()) {
            for (DataSetInfoType dataSetInfo : this.cardApplication.getDataSetInfo()) {
                this.dataSetNameList.getDataSetName().add(dataSetInfo.getDataSetName());
            }
        }
        return this.dataSetNameList;
    }

    public DataSetInfoWrapper getDataSetInfo(String dataSetName) {
        if (this.dataSetInfos.isEmpty()) {
            for (DataSetInfoType dataSetInfo : this.cardApplication.getDataSetInfo()) {
                this.dataSetInfos.put(dataSetInfo.getDataSetName(), new DataSetInfoWrapper(dataSetInfo));
            }
        }
        return this.dataSetInfos.get(dataSetName);
    }
}

