/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilities;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilitiesResponse;
import iso.std.iso_iec._24727.tech.schema.SlotCapabilityType;
import java.util.List;
import java.util.Map;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.ifd.PACECapabilities;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.FunctionType;
import org.openecard.common.sal.ProtocolStep;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.crypto.common.asn1.cvc.CHAT;
import org.openecard.crypto.common.asn1.cvc.CHATVerifier;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificateChain;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificateVerifier;
import org.openecard.crypto.common.asn1.cvc.CertificateDescription;
import org.openecard.crypto.common.asn1.eac.SecurityInfos;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.sal.protocol.eac.EACData;
import org.openecard.sal.protocol.eac.actions.CHATStepAction;
import org.openecard.sal.protocol.eac.actions.PINStepAction;
import org.openecard.sal.protocol.eac.anytype.EAC1InputType;
import org.openecard.sal.protocol.eac.anytype.EAC1OutputType;
import org.openecard.sal.protocol.eac.anytype.PasswordID;
import org.openecard.sal.protocol.eac.gui.CHATStep;
import org.openecard.sal.protocol.eac.gui.CVCStep;
import org.openecard.sal.protocol.eac.gui.PINStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PACEStep
implements ProtocolStep<DIDAuthenticate, DIDAuthenticateResponse> {
    private static final Logger logger = LoggerFactory.getLogger(PACEStep.class.getName());
    private static final String TITLE = "eac_user_consent_title";
    private final I18n lang = I18n.getTranslation("eac");
    private final Dispatcher dispatcher;
    private final UserConsent gui;

    public PACEStep(Dispatcher dispatcher, UserConsent gui) {
        this.dispatcher = dispatcher;
        this.gui = gui;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.DIDAuthenticate;
    }

    @Override
    public DIDAuthenticateResponse perform(DIDAuthenticate request, Map<String, Object> internalData) {
        DIDAuthenticate didAuthenticate = request;
        DIDAuthenticateResponse response = new DIDAuthenticateResponse();
        byte[] slotHandle = didAuthenticate.getConnectionHandle().getSlotHandle();
        try {
            EAC1InputType eac1Input = new EAC1InputType(didAuthenticate.getAuthenticationProtocolData());
            EAC1OutputType eac1Output = eac1Input.getOutputType();
            CardStateEntry cardState = (CardStateEntry)internalData.get("cardState");
            boolean nativePace = this.genericPACESupport(cardState.handleCopy());
            CardVerifiableCertificateChain certChain = new CardVerifiableCertificateChain(eac1Input.getCertificates());
            byte[] rawCertificateDescription = eac1Input.getCertificateDescription();
            CertificateDescription certDescription = CertificateDescription.getInstance(rawCertificateDescription);
            CHAT requiredCHAT = new CHAT(eac1Input.getRequiredCHAT());
            CHAT optionalCHAT = new CHAT(eac1Input.getOptionalCHAT());
            byte pinID = PasswordID.valueOf(didAuthenticate.getDIDName()).getByte();
            String passwordType = PasswordID.parse(pinID).getString();
            CardVerifiableCertificate taCert = certChain.getTerminalCertificates().get(0);
            CardVerifiableCertificateVerifier.verify(taCert, certDescription);
            CHATVerifier.verfiy(taCert.getCHAT(), optionalCHAT);
            CHATVerifier.verfiy(taCert.getCHAT(), requiredCHAT);
            CHATVerifier.verfiy(taCert.getCHAT(), optionalCHAT);
            EACData eacData = new EACData();
            eacData.didRequest = didAuthenticate;
            eacData.certificate = certChain.getTerminalCertificates().get(0);
            eacData.certificateDescription = certDescription;
            eacData.rawCertificateDescription = rawCertificateDescription;
            eacData.requiredCHAT = requiredCHAT;
            eacData.optionalCHAT = optionalCHAT;
            eacData.selectedCHAT = requiredCHAT;
            eacData.pinID = pinID;
            eacData.passwordType = passwordType;
            UserConsentDescription uc = new UserConsentDescription(this.lang.translationForKey(TITLE, new Object[0]));
            CVCStep cvcStep = new CVCStep(eacData);
            CHATStep chatStep = new CHATStep(eacData);
            PINStep pinStep = new PINStep(eacData, !nativePace);
            uc.getSteps().add(cvcStep);
            uc.getSteps().add(chatStep);
            uc.getSteps().add(pinStep);
            CHATStepAction chatAction = new CHATStepAction(eacData, chatStep);
            chatStep.setAction(chatAction);
            PINStepAction pinAction = new PINStepAction(eacData, !nativePace, slotHandle, this.dispatcher, pinStep);
            pinStep.setAction(pinAction);
            UserConsentNavigator navigator = this.gui.obtainNavigator(uc);
            ExecutionEngine exec = new ExecutionEngine(navigator);
            ResultStatus guiResult = exec.process();
            if (guiResult == ResultStatus.CANCEL) {
                String msg = "User Consent was cancelled by the user.";
                Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#cancellationByUser", msg);
                response.setResult(r);
                return response;
            }
            DIDAuthenticationDataType data = eacData.paceResponse.getAuthenticationProtocolData();
            AuthDataMap paceOutputMap = new AuthDataMap(data);
            int retryCounter = Integer.valueOf(paceOutputMap.getContentAsString("RetryCounter"));
            byte[] efCardAccess = paceOutputMap.getContentAsBytes("EFCardAccess");
            byte[] currentCAR = paceOutputMap.getContentAsBytes("CARcurr");
            byte[] previousCAR = paceOutputMap.getContentAsBytes("CARprev");
            byte[] idpicc = paceOutputMap.getContentAsBytes("IDPICC");
            SecurityInfos securityInfos = SecurityInfos.getInstance(efCardAccess);
            internalData.put("SecurityInfos", securityInfos);
            internalData.put("AuthenticatedAuxiliaryData", eac1Input.getAuthenticatedAuxiliaryData());
            internalData.put("Certificates", certChain);
            internalData.put("CurrentCAR", currentCAR);
            eac1Output.setEFCardAccess(efCardAccess);
            eac1Output.setRetryCounter(retryCounter);
            eac1Output.setIDPICC(idpicc);
            eac1Output.setCHAT(eacData.selectedCHAT.toByteArray());
            eac1Output.setCAR(currentCAR);
            response.setResult(WSHelper.makeResultOK());
            response.setAuthenticationProtocolData(eac1Output.getAuthDataType());
        }
        catch (WSHelper.WSException e) {
            logger.error(e.getMessage(), e);
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResultUnknownError(e.getMessage()));
        }
        return response;
    }

    private boolean genericPACESupport(ConnectionHandleType connectionHandle) throws Exception {
        GetIFDCapabilities capabilitiesRequest = new GetIFDCapabilities();
        capabilitiesRequest.setContextHandle(connectionHandle.getContextHandle());
        capabilitiesRequest.setIFDName(connectionHandle.getIFDName());
        GetIFDCapabilitiesResponse capabilitiesResponse = (GetIFDCapabilitiesResponse)this.dispatcher.deliver(capabilitiesRequest);
        WSHelper.checkResult(capabilitiesResponse);
        if (capabilitiesResponse.getIFDCapabilities() != null) {
            List<SlotCapabilityType> capabilities = capabilitiesResponse.getIFDCapabilities().getSlotCapability();
            String genericPACE = PACECapabilities.PACECapability.GenericPACE.getProtocol();
            for (SlotCapabilityType capability : capabilities) {
                if (!capability.getIndex().equals(connectionHandle.getSlotIndex())) continue;
                for (String protocol : capability.getProtocol()) {
                    if (!protocol.equals(genericPACE)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

