/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin.gui;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.ControlIFD;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import iso.std.iso_iec._24727.tech.schema.EstablishChannel;
import iso.std.iso_iec._24727.tech.schema.EstablishChannelResponse;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PasswordTypeType;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.apdu.ResetRetryCounter;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.StringUtils;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.reader.PCSCPinModify;
import org.openecard.plugins.pinplugin.RecognizedState;
import org.openecard.plugins.pinplugin.gui.CANEntryStep;
import org.openecard.plugins.pinplugin.gui.CANStepAction;
import org.openecard.plugins.pinplugin.gui.ChangePINStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PINStepAction
extends StepAction {
    private static final Logger logger = LoggerFactory.getLogger(PINStepAction.class);
    private final I18n lang = I18n.getTranslation("pinplugin");
    private static final String PINSTEP_TITLE = "action.changepin.userconsent.pinstep.title";
    private static final String CANSTEP_TITLE = "action.changepin.userconsent.canstep.title";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String PIN_ID_PIN = "3";
    private final boolean capturePin;
    private final ConnectionHandleType conHandle;
    private final Dispatcher dispatcher;
    private int retryCounter;
    private String oldPIN;
    private byte[] newPIN;
    private byte[] newPINRepeat;

    public PINStepAction(boolean capturePin, ConnectionHandleType conHandle, Dispatcher dispatcher, Step step, int retryCounter) {
        super(step);
        this.capturePin = capturePin;
        this.conHandle = conHandle;
        this.dispatcher = dispatcher;
        this.retryCounter = retryCounter;
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        AuthDataMap tmp;
        if (result.isBack()) {
            return new StepActionResult(StepActionResultStatus.BACK);
        }
        DIDAuthenticationDataType paceInput = new DIDAuthenticationDataType();
        paceInput.setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        try {
            tmp = new AuthDataMap(paceInput);
        }
        catch (ParserConfigurationException ex) {
            logger.error("Failed to read empty Protocol data.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        AuthDataResponse paceInputMap = tmp.createResponse(paceInput);
        if (this.capturePin) {
            ExecutionResults executionResults = oldResults.get(this.getStepID());
            if (!this.verifyUserInput(executionResults)) {
                return new StepActionResult(StepActionResultStatus.REPEAT, this.createPINReplacementStep(false, true));
            }
            paceInputMap.addElement("PIN", this.oldPIN);
        }
        paceInputMap.addElement("PinID", PIN_ID_PIN);
        EstablishChannel establishChannel = new EstablishChannel();
        establishChannel.setSlotHandle(this.conHandle.getSlotHandle());
        establishChannel.setAuthenticationProtocolData(paceInputMap.getResponse());
        establishChannel.getAuthenticationProtocolData().setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        try {
            EstablishChannelResponse establishChannelResponse = (EstablishChannelResponse)this.dispatcher.deliver(establishChannel);
            WSHelper.checkResult(establishChannelResponse);
            if (this.capturePin) {
                this.sendResetRetryCounter();
            } else {
                this.sendModifyPIN();
            }
            Disconnect disconnect = new Disconnect();
            disconnect.setSlotHandle(this.conHandle.getSlotHandle());
            try {
                this.dispatcher.deliver(disconnect);
            }
            catch (IllegalArgumentException ex) {
                logger.error("Failed to transmit Disconnect command.", ex);
            }
            catch (InvocationTargetException ex) {
                logger.error("Failed to transmit Disconnect command.", ex);
            }
            catch (DispatcherException ex) {
                logger.error("Failed to transmit Disconnect command.", ex);
            }
            return new StepActionResult(StepActionResultStatus.NEXT);
        }
        catch (WSHelper.WSException ex) {
            if (this.capturePin) {
                --this.retryCounter;
                logger.info("Wrong PIN entered, trying again (remaining tries {}).", (Object)this.retryCounter);
                if (this.retryCounter == 1) {
                    Step replacementStep = this.createCANReplacementStep();
                    return new StepActionResult(StepActionResultStatus.BACK, replacementStep);
                }
                Step replacementStep = this.createPINReplacementStep(true, false);
                return new StepActionResult(StepActionResultStatus.REPEAT, replacementStep);
            }
            logger.warn("PIN not entered successfully in terminal.");
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        catch (InvocationTargetException ex) {
            logger.error("Failed to dispatch EstablishChannelCommand.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        catch (APDUException ex) {
            logger.error("Failed to transmit Reset Retry Counter APDU.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        catch (IllegalArgumentException ex) {
            logger.error("Failed to transmit Reset Retry Counter APDU.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        catch (IFDException ex) {
            logger.error("Failed to transmit Reset Retry Counter APDU.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        catch (DispatcherException ex) {
            logger.error("Failed to transmit Reset Retry Counter APDU.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
    }

    private Step createCANReplacementStep() {
        String title = this.lang.translationForKey(CANSTEP_TITLE, new Object[0]);
        RecognizedState state = RecognizedState.PIN_suspended;
        CANEntryStep canStep = new CANEntryStep("can-entry", title, this.capturePin, state, false, false);
        CANStepAction pinAction = new CANStepAction(this.capturePin, this.conHandle, this.dispatcher, canStep, state);
        canStep.setAction(pinAction);
        return canStep;
    }

    private void sendModifyPIN() throws IFDException, InvocationTargetException, DispatcherException {
        PasswordAttributesType pwdAttr = PINStepAction.create(true, PasswordTypeType.ASCII_NUMERIC, 6, 6, 6);
        pwdAttr.setPadChar(new byte[]{63});
        PCSCPinModify ctrlStruct = new PCSCPinModify(pwdAttr, StringUtils.toByteArray("002C0203"));
        byte[] structData = ctrlStruct.toBytes();
        ControlIFD controlIFD = new ControlIFD();
        controlIFD.setCommand(ByteUtils.concatenate((byte)7, structData));
        controlIFD.setContextHandle(this.conHandle.getContextHandle());
        controlIFD.setIFDName(this.conHandle.getIFDName());
        this.dispatcher.deliver(controlIFD);
    }

    private void sendResetRetryCounter() throws APDUException {
        ResetRetryCounter apdu = new ResetRetryCounter(this.newPIN, 3);
        apdu.transmit(this.dispatcher, this.conHandle.getSlotHandle());
    }

    private static PasswordAttributesType create(boolean needsPadding, PasswordTypeType pwdType, int minLen, int storedLen, int maxLen) {
        PasswordAttributesType r = new PasswordAttributesType();
        r.setMinLength(BigInteger.valueOf(minLen));
        r.setStoredLength(BigInteger.valueOf(storedLen));
        r.setPwdType(pwdType);
        if (needsPadding) {
            r.getPwdFlags().add("needs-padding");
        }
        r.setMaxLength(BigInteger.valueOf(maxLen));
        return r;
    }

    private boolean verifyUserInput(ExecutionResults executionResults) {
        PasswordField fieldOldPIN = (PasswordField)executionResults.getResult("OLD_PIN_FIELD");
        PasswordField fieldNewPIN = (PasswordField)executionResults.getResult("NEW_PIN_FIELD");
        PasswordField fieldNewPINRepeat = (PasswordField)executionResults.getResult("NEW_PIN_REPEAT_FIELD");
        this.oldPIN = fieldOldPIN.getValue();
        if (this.oldPIN.isEmpty()) {
            return false;
        }
        if (fieldNewPIN.getValue().isEmpty()) {
            return false;
        }
        try {
            this.newPIN = fieldNewPIN.getValue().getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        if (fieldNewPINRepeat.getValue().isEmpty()) {
            return false;
        }
        try {
            this.newPINRepeat = fieldNewPINRepeat.getValue().getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        return ByteUtils.compare(this.newPIN, this.newPINRepeat);
    }

    private Step createPINReplacementStep(boolean enteredWrong, boolean verifyFailed) {
        String title = this.lang.translationForKey(PINSTEP_TITLE, new Object[0]);
        ChangePINStep changePINStep = new ChangePINStep("pin-entry", title, this.capturePin, this.retryCounter, enteredWrong, verifyFailed);
        PINStepAction pinAction = new PINStepAction(this.capturePin, this.conHandle, this.dispatcher, changePINStep, this.retryCounter);
        changePINStep.setAction(pinAction);
        return changePINStep;
    }
}

