/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.handler;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.RequestLine;
import org.openecard.apache.http.entity.StringEntity;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.control.ControlException;
import org.openecard.control.binding.http.HTTPException;
import org.openecard.control.binding.http.common.HeaderTypes;
import org.openecard.control.binding.http.common.Http11Response;
import org.openecard.control.binding.http.handler.HttpControlHandler;
import org.openecard.control.module.tctoken.GenericTCTokenHandler;
import org.openecard.control.module.tctoken.TCTokenRequest;
import org.openecard.control.module.tctoken.TCTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTCTokenHandler
extends HttpControlHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpTCTokenHandler.class);
    private final GenericTCTokenHandler genericTCTokenHandler;

    public HttpTCTokenHandler(GenericTCTokenHandler genericTCTokenHandler) {
        super("/eID-Client");
        this.genericTCTokenHandler = genericTCTokenHandler;
    }

    private HttpResponse handleResponse(TCTokenResponse response) throws ControlException, Exception {
        Http11Response httpResponse = new Http11Response(400);
        Result result = response.getResult();
        if (result.getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok")) {
            if (response.getRefreshAddress() != null) {
                return this.handleRedirectResponse(response.getRefreshAddress());
            }
            httpResponse.setStatusCode(500);
        } else {
            if (result.getResultMessage().getValue() != null) {
                return this.handleErrorResponse(result.getResultMessage().getValue());
            }
            httpResponse.setStatusCode(500);
        }
        return httpResponse;
    }

    private HttpResponse handleRedirectResponse(URL location) {
        Http11Response httpResponse = new Http11Response(303);
        httpResponse.setHeader(HeaderTypes.LOCATION.fieldName(), location.toString());
        return httpResponse;
    }

    private HttpResponse handleErrorResponse(String message) throws UnsupportedEncodingException {
        Http11Response httpResponse = new Http11Response(400);
        httpResponse.setEntity(new StringEntity(message, "UTF-8"));
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext context) throws IOException {
        block10: {
            logger.debug("HTTP request: {}", (Object)httpRequest.toString());
            HttpResponse response = null;
            try {
                RequestLine requestLine = httpRequest.getRequestLine();
                URI requestURI = URI.create(requestLine.getUri());
                if (!requestLine.getMethod().equals("GET")) {
                    throw new HTTPException(405);
                }
                TCTokenRequest tcTokenRequest = this.genericTCTokenHandler.parseTCTokenRequestURI(requestURI);
                TCTokenResponse tcTokenResponse = this.genericTCTokenHandler.handleActivate(tcTokenRequest);
                response = this.handleResponse(tcTokenResponse);
                response.setParams(httpRequest.getParams());
                Http11Response.copyHttpResponse(response, httpResponse);
                Http11Response.copyHttpResponse(response, httpResponse);
            }
            catch (ControlException e) {
                httpResponse = new Http11Response(400);
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    httpResponse.setEntity(new StringEntity(e.getMessage(), "UTF-8"));
                }
                if (e instanceof HTTPException) {
                    httpResponse.setStatusCode(((HTTPException)e).getHTTPStatusCode());
                }
                break block10;
            }
            catch (Exception e2) {
                httpResponse = new Http11Response(500);
                logger.error(e2.getMessage(), e2);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Http11Response.copyHttpResponse(response, httpResponse);
                logger.debug("HTTP response: {}", (Object)response);
                logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
            }
            logger.debug("HTTP response: {}", (Object)response);
            logger.debug("HTTP request handled by: {}", (Object)this.getClass().getName());
        }
    }
}

