/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.monitor;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilesystemAlterationObserverImpl
implements FilesystemAlterationObserver {
    private final Log log = LogFactory.getLog(FilesystemAlterationObserverImpl.class);
    private final File rootDirectory;
    private final Entry rootEntry;
    private FilesystemAlterationListener[] listeners = new FilesystemAlterationListener[0];
    private Set listenersSet = new HashSet();

    public FilesystemAlterationObserverImpl(File pRootDirectory) {
        this.rootDirectory = pRootDirectory;
        this.rootEntry = new Entry(new MonitorFileImpl(pRootDirectory));
    }

    private void notifyOnStart() {
        this.log.debug("onStart " + this.rootEntry);
        for (int i = 0; i < this.listeners.length; ++i) {
            FilesystemAlterationListener listener = this.listeners[i];
            listener.onStart(this);
        }
    }

    private void notifyOnStop() {
        this.log.debug("onStop " + this.rootEntry);
        for (int i = 0; i < this.listeners.length; ++i) {
            FilesystemAlterationListener listener = this.listeners[i];
            listener.onStop(this);
        }
    }

    private void notifyOnFileCreate(Entry pEntry) {
        this.log.debug("onFileCreate " + pEntry);
        for (int i = 0; i < this.listeners.length; ++i) {
            FilesystemAlterationListener listener = this.listeners[i];
            listener.onFileCreate(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void notifyOnFileChange(Entry pEntry) {
        this.log.debug("onFileChange " + pEntry);
        for (int i = 0; i < this.listeners.length; ++i) {
            FilesystemAlterationListener listener = this.listeners[i];
            listener.onFileChange(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void notifyOnFileDelete(Entry pEntry) {
        this.log.debug("onFileDelete " + pEntry);
        for (int i = 0; i < this.listeners.length; ++i) {
            FilesystemAlterationListener listener = this.listeners[i];
            listener.onFileDelete(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void notifyOnDirectoryCreate(Entry pEntry) {
        this.log.debug("onDirectoryCreate " + pEntry);
        for (int i = 0; i < this.listeners.length; ++i) {
            FilesystemAlterationListener listener = this.listeners[i];
            listener.onDirectoryCreate(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void notifyOnDirectoryChange(Entry pEntry) {
        this.log.debug("onDirectoryChange " + pEntry);
        for (int i = 0; i < this.listeners.length; ++i) {
            FilesystemAlterationListener listener = this.listeners[i];
            listener.onDirectoryChange(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void notifyOnDirectoryDelete(Entry pEntry) {
        this.log.debug("onDirectoryDelete " + pEntry);
        for (int i = 0; i < this.listeners.length; ++i) {
            FilesystemAlterationListener listener = this.listeners[i];
            listener.onDirectoryDelete(((MonitorFileImpl)pEntry.getFile()).file);
        }
    }

    private void checkEntries() {
        if (this.rootEntry.needsToBeDeleted()) {
            this.rootEntry.lastType = 0;
        }
    }

    public synchronized void checkAndNotify() {
        if (this.listeners.length == 0) {
            return;
        }
        this.notifyOnStart();
        this.checkEntries();
        this.notifyOnStop();
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public synchronized void addListener(FilesystemAlterationListener pListener) {
        if (this.listenersSet.add(pListener)) {
            this.createArrayFromSet();
        }
    }

    public synchronized void removeListener(FilesystemAlterationListener pListener) {
        if (this.listenersSet.remove(pListener)) {
            this.createArrayFromSet();
        }
    }

    private void createArrayFromSet() {
        FilesystemAlterationListener[] newListeners = new FilesystemAlterationListener[this.listenersSet.size()];
        this.listenersSet.toArray(newListeners);
        this.listeners = newListeners;
    }

    public FilesystemAlterationListener[] getListeners() {
        return this.listeners;
    }

    public static void main(String[] args) {
        FilesystemAlterationObserverImpl observer = new FilesystemAlterationObserverImpl(new File(args[0]));
        while (true) {
            observer.checkEntries();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private final class Entry {
        private static final int TYPE_UNKNOWN = 0;
        private static final int TYPE_FILE = 1;
        private static final int TYPE_DIRECTORY = 2;
        private final MonitorFile file;
        private long lastModified = -1L;
        private int lastType = 0;
        private Map childs = new HashMap();

        public Entry(MonitorFile pFile) {
            this.file = pFile;
        }

        public String getName() {
            return this.file.getName();
        }

        public String toString() {
            return this.file.toString();
        }

        private void compareChilds() {
            if (!this.file.isDirectory()) {
                return;
            }
            MonitorFile[] files = this.file.listFiles();
            HashSet deleted = new HashSet(this.childs.values());
            for (int i = 0; i < files.length; ++i) {
                MonitorFile f = files[i];
                String name = f.getName();
                Entry entry = (Entry)this.childs.get(name);
                if (entry != null) {
                    deleted.remove(entry);
                    if (!entry.needsToBeDeleted()) continue;
                    this.childs.remove(name);
                    continue;
                }
                Entry newChild = new Entry(f);
                this.childs.put(name, newChild);
                newChild.needsToBeDeleted();
            }
            Iterator it = deleted.iterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                entry.deleteChildsAndNotify();
                this.childs.remove(entry.getName());
            }
        }

        private void deleteChildsAndNotify() {
            Iterator it = this.childs.values().iterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                entry.deleteChildsAndNotify();
            }
            this.childs.clear();
            if (this.lastType == 2) {
                FilesystemAlterationObserverImpl.this.notifyOnDirectoryDelete(this);
            } else if (this.lastType == 1) {
                FilesystemAlterationObserverImpl.this.notifyOnFileDelete(this);
            }
        }

        public boolean needsToBeDeleted() {
            if (!this.file.exists()) {
                this.deleteChildsAndNotify();
                return true;
            }
            long currentModified = this.file.lastModified();
            if (currentModified != this.lastModified) {
                int newType;
                this.lastModified = currentModified;
                int n = newType = this.file.isDirectory() ? 2 : 1;
                if (this.lastType != newType) {
                    this.deleteChildsAndNotify();
                    this.lastType = newType;
                    if (newType == 2) {
                        FilesystemAlterationObserverImpl.this.notifyOnDirectoryCreate(this);
                        this.compareChilds();
                    } else {
                        FilesystemAlterationObserverImpl.this.notifyOnFileCreate(this);
                    }
                    return false;
                }
                if (newType == 2) {
                    FilesystemAlterationObserverImpl.this.notifyOnDirectoryChange(this);
                    this.compareChilds();
                } else {
                    FilesystemAlterationObserverImpl.this.notifyOnFileChange(this);
                }
                return false;
            }
            this.compareChilds();
            return false;
        }

        public MonitorFile getFile() {
            return this.file;
        }

        public void markNotChanged() {
            this.lastModified = this.file.lastModified();
        }
    }

    private static final class MonitorFileImpl
    implements MonitorFile {
        private final File file;

        public MonitorFileImpl(File pFile) {
            this.file = pFile;
        }

        public boolean exists() {
            return this.file.exists();
        }

        public MonitorFile[] listFiles() {
            File[] childs = this.file.listFiles();
            MonitorFile[] providers = new MonitorFile[childs.length];
            for (int i = 0; i < providers.length; ++i) {
                providers[i] = new MonitorFileImpl(childs[i]);
            }
            return providers;
        }

        public String getName() {
            return this.file.getName();
        }

        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        public long lastModified() {
            return this.file.lastModified();
        }

        public String toString() {
            return this.file.toString();
        }
    }

    private static interface MonitorFile {
        public long lastModified();

        public MonitorFile[] listFiles();

        public boolean isDirectory();

        public boolean exists();

        public String getName();
    }
}

