/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.paos;

import iso.std.iso_iec._24727.tech.schema.ResponseType;
import iso.std.iso_iec._24727.tech.schema.StartPAOS;
import iso.std.iso_iec._24727.tech.schema.StartPAOSResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.RequestLine;
import org.openecard.apache.http.StatusLine;
import org.openecard.apache.http.entity.ContentType;
import org.openecard.apache.http.entity.StringEntity;
import org.openecard.apache.http.impl.DefaultConnectionReuseStrategy;
import org.openecard.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.openecard.apache.http.protocol.BasicHttpContext;
import org.openecard.apache.http.protocol.HttpRequestExecutor;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.TlsClient;
import org.openecard.bouncycastle.crypto.tls.TlsProtocolHandler;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.io.ProxySettings;
import org.openecard.common.util.FileUtils;
import org.openecard.transport.httpcore.HttpRequestHelper;
import org.openecard.transport.httpcore.StreamHttpClientConnection;
import org.openecard.transport.paos.MessageIdGenerator;
import org.openecard.transport.paos.PAOSException;
import org.openecard.ws.marshal.MarshallingTypeException;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.openecard.ws.soap.SOAPException;
import org.openecard.ws.soap.SOAPHeader;
import org.openecard.ws.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PAOS {
    private static final Logger logger = LoggerFactory.getLogger(PAOS.class);
    public static final QName RELATES_TO = new QName("http://www.w3.org/2005/03/addressing", "RelatesTo");
    public static final QName REPLY_TO = new QName("http://www.w3.org/2005/03/addressing", "ReplyTo");
    public static final QName MESSAGE_ID = new QName("http://www.w3.org/2005/03/addressing", "MessageID");
    public static final QName ADDRESS = new QName("http://www.w3.org/2005/03/addressing", "Address");
    public static final QName PAOS_PAOS = new QName("urn:liberty:paos:2006-08", "PAOS");
    public static final QName PAOS_VERSION = new QName("urn:liberty:paos:2006-08", "Version");
    public static final QName PAOS_ENDPOINTREF = new QName("urn:liberty:paos:2006-08", "EndpointReference");
    public static final QName PAOS_ADDRESS = new QName("urn:liberty:paos:2006-08", "Address");
    public static final QName PAOS_METADATA = new QName("urn:liberty:paos:2006-08", "MetaData");
    public static final QName PAOS_SERVICETYPE = new QName("urn:liberty:paos:2006-08", "ServiceType");
    private final MessageIdGenerator idGenerator;
    private final WSMarshaller m;
    private final URL endpoint;
    private final Dispatcher dispatcher;
    private final TlsClient tlsClient;

    public PAOS(URL endpoint, Dispatcher dispatcher) throws PAOSException {
        this(endpoint, dispatcher, null);
    }

    public PAOS(URL endpoint, Dispatcher dispatcher, TlsClient tlsClient) throws PAOSException {
        this.endpoint = endpoint;
        this.dispatcher = dispatcher;
        this.tlsClient = tlsClient;
        try {
            this.idGenerator = new MessageIdGenerator();
            this.m = WSMarshallerFactory.createInstance();
        }
        catch (WSMarshallerException e) {
            logger.error(e.getMessage(), e);
            throw new PAOSException(e);
        }
    }

    private String getRelatesTo(SOAPMessage msg) throws SOAPException {
        return this.getHeaderElement(msg, RELATES_TO);
    }

    private void setRelatesTo(SOAPMessage msg, String value) throws SOAPException {
        Element elem = this.getHeaderElement(msg, RELATES_TO, true);
        elem.setTextContent(value);
    }

    private String getHeaderElement(SOAPMessage msg, QName elem) throws SOAPException {
        Element headerElem = this.getHeaderElement(msg, elem, false);
        return headerElem == null ? null : headerElem.getTextContent().trim();
    }

    private Element getHeaderElement(SOAPMessage msg, QName elem, boolean create) throws SOAPException {
        Element result = null;
        SOAPHeader h = msg.getSOAPHeader();
        for (Element e : h.getChildElements()) {
            if (!e.getLocalName().equals(elem.getLocalPart()) || !e.getNamespaceURI().equals(elem.getNamespaceURI())) continue;
            result = e;
            break;
        }
        if (result == null && create) {
            result = h.addHeaderElement(elem);
        }
        return result;
    }

    private void addMessageIDs(SOAPMessage msg) throws SOAPException {
        String otherID = this.idGenerator.getRemoteID();
        String newID = this.idGenerator.createNewID();
        if (otherID != null) {
            this.setRelatesTo(msg, otherID);
        }
        this.setMessageID(msg, newID);
    }

    private void updateMessageID(SOAPMessage msg) throws PAOSException {
        try {
            String id = this.getMessageID(msg);
            if (id == null) {
                throw new PAOSException("No MessageID in PAOS header.");
            }
            if (!this.idGenerator.setRemoteID(id)) {
                throw new PAOSException("MessageID from result doesn't match.");
            }
        }
        catch (SOAPException e) {
            logger.error(e.getMessage(), e);
            throw new PAOSException(e.getMessage(), e);
        }
    }

    private String getMessageID(SOAPMessage msg) throws SOAPException {
        return this.getHeaderElement(msg, MESSAGE_ID);
    }

    private void setMessageID(SOAPMessage msg, String value) throws SOAPException {
        Element elem = this.getHeaderElement(msg, MESSAGE_ID, true);
        elem.setTextContent(value);
    }

    private Object processPAOSRequest(InputStream content) throws PAOSException {
        try {
            Document doc = this.m.str2doc(content);
            SOAPMessage msg = this.m.doc2soap(doc);
            this.updateMessageID(msg);
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("Message received:\n{}", (Object)this.m.doc2str(doc));
                }
                catch (TransformerException ex) {
                    logger.warn("Failed to log PAOS request message.", ex);
                }
            }
            return this.m.unmarshal(msg.getSOAPBody().getChildElements().get(0));
        }
        catch (MarshallingTypeException ex) {
            logger.error(ex.getMessage(), ex);
            throw new PAOSException(ex.getMessage(), ex);
        }
        catch (WSMarshallerException ex) {
            logger.error(ex.getMessage(), ex);
            throw new PAOSException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), ex);
            throw new PAOSException(ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            logger.error(ex.getMessage(), ex);
            throw new PAOSException(ex.getMessage(), ex);
        }
    }

    private String createPAOSResponse(Object obj) throws MarshallingTypeException, SOAPException, TransformerException {
        SOAPMessage msg = this.createSOAPMessage(obj);
        String result = this.m.doc2str(msg.getDocument());
        logger.debug("Message sent:\n{}", (Object)result);
        return result;
    }

    private SOAPMessage createSOAPMessage(Object content) throws MarshallingTypeException, SOAPException {
        Document contentDoc = this.m.marshal(content);
        SOAPMessage msg = this.m.add2soap(contentDoc);
        SOAPHeader header = msg.getSOAPHeader();
        Element paos = header.addHeaderElement(PAOS_PAOS);
        paos.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor", "http://schemas.xmlsoap.org/soap/actor/next");
        paos.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand", "1");
        Element version = header.addChildElement(paos, PAOS_VERSION);
        version.setTextContent("urn:liberty:paos:2006-08");
        Element endpointReference = header.addChildElement(paos, PAOS_ENDPOINTREF);
        Element address = header.addChildElement(endpointReference, PAOS_ADDRESS);
        address.setTextContent("http://www.projectliberty.org/2006/01/role/paos");
        Element metaData = header.addChildElement(endpointReference, PAOS_METADATA);
        Element serviceType = header.addChildElement(metaData, PAOS_SERVICETYPE);
        serviceType.setTextContent("http://www.bsi.bund.de/ecard/api/1.1/PAOS/GetNextCommand");
        Element replyTo = header.addHeaderElement(REPLY_TO);
        address = header.addChildElement(replyTo, ADDRESS);
        address.setTextContent("http://www.projectliberty.org/2006/02/role/paos");
        this.addMessageIDs(msg);
        return msg;
    }

    public StartPAOSResponse sendStartPAOS(StartPAOS message) throws DispatcherException, PAOSException {
        Object msg = message;
        String hostname = this.endpoint.getHost();
        int port = this.endpoint.getPort();
        if (port == -1) {
            port = this.endpoint.getDefaultPort();
        }
        String resource = this.endpoint.getFile();
        try {
            while (true) {
                HttpResponse response;
                boolean isReusable;
                StreamHttpClientConnection conn;
                try {
                    conn = this.createTlsConnection(hostname, port, ProtocolVersion.TLSv11);
                }
                catch (IOException ex) {
                    logger.error("Connecting to the PAOS endpoint with TLSv1.1 failed. Falling back to TLSv1.0.");
                    conn = this.createTlsConnection(hostname, port, ProtocolVersion.TLSv10);
                }
                BasicHttpContext ctx = new BasicHttpContext();
                HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
                DefaultConnectionReuseStrategy reuse = new DefaultConnectionReuseStrategy();
                do {
                    BasicHttpEntityEnclosingRequest req = new BasicHttpEntityEnclosingRequest("POST", resource);
                    req.setParams(conn.getParams());
                    HttpRequestHelper.setDefaultHeader(req, hostname);
                    req.setHeader("PAOS", "ver=\"urn:liberty:2003-08\",\"urn:liberty:2006-08\";http://www.bsi.bund.de/ecard/api/1.1/PAOS/GetNextCommand");
                    req.setHeader("Accept", "application/vnd.paos+xml");
                    ContentType reqContentType = ContentType.create("application/vnd.paos+xml", "UTF-8");
                    PAOS.dumpHttpRequest("HTTP Request (before adding content):", req);
                    String reqMsgStr = this.createPAOSResponse(msg);
                    StringEntity reqMsg = new StringEntity(reqMsgStr, reqContentType);
                    req.setEntity(reqMsg);
                    req.setHeader(reqMsg.getContentType());
                    req.setHeader("Content-Length", Long.toString(reqMsg.getContentLength()));
                    response = httpexecutor.execute(req, conn, ctx);
                    int statusCode = response.getStatusLine().getStatusCode();
                    conn.receiveResponseEntity(response);
                    HttpEntity entity = response.getEntity();
                    byte[] entityData = FileUtils.toByteArray(entity.getContent());
                    PAOS.dumpHttpResponse(response, entityData);
                    this.checkHTTPStatusCode(msg, statusCode);
                    Object requestObj = this.processPAOSRequest(new ByteArrayInputStream(entityData));
                    if (requestObj instanceof StartPAOSResponse) {
                        StartPAOSResponse startPAOSResponse = (StartPAOSResponse)requestObj;
                        WSHelper.checkResult(startPAOSResponse);
                        return startPAOSResponse;
                    }
                    msg = this.dispatcher.deliver(requestObj);
                } while (isReusable = reuse.keepAlive(response, ctx));
            }
        }
        catch (HttpException ex) {
            throw new PAOSException("Failed to deliver or receive PAOS HTTP message.", ex);
        }
        catch (IOException ex) {
            throw new PAOSException(ex);
        }
        catch (SOAPException ex) {
            throw new PAOSException("Failed to create SOAP message instance from given JAXB message.", ex);
        }
        catch (URISyntaxException ex) {
            throw new PAOSException("Hostname or port of the remote server are invalid.", ex);
        }
        catch (MarshallingTypeException ex) {
            throw new DispatcherException("Failed to marshal JAXB object.", ex);
        }
        catch (InvocationTargetException ex) {
            throw new DispatcherException("The dispatched method threw an exception.", ex);
        }
        catch (TransformerException ex) {
            throw new DispatcherException(ex);
        }
        catch (WSHelper.WSException ex) {
            throw new PAOSException(ex);
        }
    }

    private StreamHttpClientConnection createTlsConnection(String hostname, int port, ProtocolVersion tlsVersion) throws IOException, URISyntaxException {
        StreamHttpClientConnection conn;
        Socket socket = ProxySettings.getDefault().getSocket(hostname, port);
        if (this.tlsClient != null) {
            this.tlsClient.setClientVersion(tlsVersion);
            InputStream sockIn = socket.getInputStream();
            OutputStream sockOut = socket.getOutputStream();
            TlsProtocolHandler handler = new TlsProtocolHandler(sockIn, sockOut);
            handler.connect(this.tlsClient);
            conn = new StreamHttpClientConnection(handler.getInputStream(), handler.getOutputStream());
        } else {
            conn = new StreamHttpClientConnection(socket.getInputStream(), socket.getOutputStream());
        }
        return conn;
    }

    private void checkHTTPStatusCode(Object msg, int statusCode) throws PAOSException {
        if (statusCode < 200 || statusCode > 299) {
            if (msg instanceof ResponseType) {
                ResponseType resp = (ResponseType)msg;
                try {
                    WSHelper.checkResult(resp);
                }
                catch (WSHelper.WSException ex) {
                    throw new PAOSException("Received HTML Error Code " + statusCode, ex);
                }
            }
            throw new PAOSException("Received HTML Error Code " + statusCode);
        }
    }

    private static void dumpHttpRequest(String msg, HttpRequest req) {
        if (logger.isDebugEnabled()) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            pw.println(msg);
            RequestLine rl = req.getRequestLine();
            pw.format("  %s %s %s%n", rl.getMethod(), rl.getUri(), rl.getProtocolVersion().toString());
            for (Header h : req.getAllHeaders()) {
                pw.format("  %s: %s%n", h.getName(), h.getValue());
            }
            pw.flush();
            logger.debug(w.toString());
        }
    }

    private static void dumpHttpResponse(HttpResponse res, byte[] entityData) {
        if (logger.isDebugEnabled()) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            pw.println("HTTP Response:");
            StatusLine sl = res.getStatusLine();
            pw.format("  %s %d %s%n", sl.getProtocolVersion().toString(), sl.getStatusCode(), sl.getReasonPhrase());
            for (Header h : res.getAllHeaders()) {
                pw.format("  %s: %s%n", h.getName(), h.getValue());
            }
            pw.format(new String(entityData), new Object[0]);
            pw.println();
            pw.flush();
            logger.debug(w.toString());
        }
    }
}

