/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.actions;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.EstablishChannel;
import iso.std.iso_iec._24727.tech.schema.EstablishChannelResponse;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.WSHelper;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.util.ByteUtils;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.sal.protocol.eac.EACData;
import org.openecard.sal.protocol.eac.anytype.PasswordID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PINStepAction
extends StepAction {
    private static final Logger logger = LoggerFactory.getLogger(PINStepAction.class);
    private final EACData eacData;
    private final boolean capturePin;
    private final byte[] slotHandle;
    private final Dispatcher dispatcher;
    private int retryCounter;

    public PINStepAction(EACData eacData, boolean capturePin, byte[] slotHandle, Dispatcher dispatcher, Step step) {
        super(step);
        this.eacData = eacData;
        this.capturePin = capturePin;
        this.slotHandle = slotHandle;
        this.dispatcher = dispatcher;
        this.retryCounter = 0;
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        AuthDataMap paceAuthMap;
        if (result.isBack()) {
            return new StepActionResult(StepActionResultStatus.BACK);
        }
        DIDAuthenticationDataType protoData = this.eacData.didRequest.getAuthenticationProtocolData();
        try {
            paceAuthMap = new AuthDataMap(protoData);
        }
        catch (ParserConfigurationException ex) {
            logger.error("Failed to read EAC Protocol data.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        AuthDataResponse paceInputMap = paceAuthMap.createResponse(protoData);
        if (this.capturePin) {
            ExecutionResults executionResults = oldResults.get(this.getStepID());
            PasswordField p = (PasswordField)executionResults.getResult("PACE_PIN_FIELD");
            String pin = p.getValue();
            if (pin.isEmpty()) {
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            paceInputMap.addElement("PIN", pin);
        }
        paceInputMap.addElement("PinID", PasswordID.parse(this.eacData.pinID).getByteAsString());
        paceInputMap.addElement("CHAT", this.eacData.selectedCHAT.toString());
        String certDesc = ByteUtils.toHexString(this.eacData.rawCertificateDescription);
        paceInputMap.addElement("CertificateDescription", certDesc);
        EstablishChannel establishChannel = new EstablishChannel();
        establishChannel.setSlotHandle(this.slotHandle);
        establishChannel.setAuthenticationProtocolData(paceInputMap.getResponse());
        establishChannel.getAuthenticationProtocolData().setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        try {
            EstablishChannelResponse establishChannelResponse = (EstablishChannelResponse)this.dispatcher.deliver(establishChannel);
            WSHelper.checkResult(establishChannelResponse);
            this.eacData.paceResponse = establishChannelResponse;
            return new StepActionResult(StepActionResultStatus.NEXT);
        }
        catch (WSHelper.WSException ex) {
            if (this.capturePin) {
                if (this.retryCounter < 2) {
                    ++this.retryCounter;
                    logger.info("Wrong PIN entered, trying again (try number {}).", (Object)this.retryCounter);
                    return new StepActionResult(StepActionResultStatus.REPEAT);
                }
                logger.warn("Wrong PIN entered {} times.", (Object)(this.retryCounter + 1));
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
            logger.warn("PIN not entered successfully in terminal.");
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        catch (DispatcherException ex) {
            logger.error("Failed to dispatch EstablishChannelCommand.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        catch (InvocationTargetException ex) {
            logger.error("Failed to dispatch EstablishChannelCommand.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
    }
}

