/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.swing.common.GUIDefaults;
import org.openecard.gui.swing.components.StepComponent;

public class ToggleText
implements StepComponent {
    private static final String TOGGLETEXT = "ToggleText";
    private static final String TOGGLETEXT_FOREGROUND = "ToggleText.foreground";
    private static final String TOGGLETEXT_BACKGROUND = "ToggleText.background";
    private static final String TOGGLETEXT_FONT = "ToggleText.font";
    private static final String TOGGLETEXT_INDICATOR_FOREGROUND = "ToggleTextIndicator.foreground";
    private static final Icon openedIndicator = GUIDefaults.getImage("ToggleText.selectedIcon");
    private static final Icon closedIndicator = GUIDefaults.getImage("ToggleText.icon");
    private JPanel rootPanel;
    private JButton button;
    private JTextArea text;

    public ToggleText(org.openecard.gui.definition.ToggleText toggleText) {
        this(toggleText.getTitle(), toggleText.getText(), toggleText.isCollapsed());
    }

    public ToggleText(String buttonText, String contentText) {
        this(buttonText, contentText, false);
    }

    public ToggleText(String buttonText, String contentText, boolean collapsed) {
        this.initComponents(buttonText, contentText);
        this.initLayout();
        this.loadUIDefaults();
        this.button.setSelected(collapsed);
        this.text.setVisible(!collapsed);
        this.button.setIcon(!collapsed ? openedIndicator : closedIndicator);
    }

    private void initComponents(String buttonText, String contentText) {
        this.rootPanel = new JPanel();
        this.button = new JButton(buttonText + "  ");
        this.text = new JTextArea(contentText);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToggleText.this.text.setVisible(!ToggleText.this.text.isVisible());
                ToggleText.this.button.setIcon(ToggleText.this.text.isVisible() ? openedIndicator : closedIndicator);
                ToggleText.this.rootPanel.revalidate();
                ToggleText.this.rootPanel.doLayout();
                ToggleText.this.rootPanel.repaint();
            }
        });
    }

    private void initLayout() {
        this.rootPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        this.rootPanel.add((Component)this.button, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.rootPanel.add((Component)this.text, gbc);
    }

    private void loadUIDefaults() {
        Font font;
        Color fgIndicator;
        Color fg;
        UIDefaults defaults = UIManager.getDefaults();
        Color bg = (Color)defaults.get(TOGGLETEXT_BACKGROUND);
        if (bg == null) {
            bg = Color.WHITE;
        }
        if ((fg = (Color)defaults.get(TOGGLETEXT_FOREGROUND)) == null) {
            fg = Color.BLACK;
        }
        if ((fgIndicator = (Color)defaults.get(TOGGLETEXT_INDICATOR_FOREGROUND)) == null) {
            fgIndicator = Color.LIGHT_GRAY;
        }
        if ((font = (Font)defaults.get(TOGGLETEXT_FONT)) == null) {
            font = this.button.getFont();
        }
        this.button.setOpaque(true);
        this.button.setFocusPainted(false);
        this.button.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.button.setHorizontalAlignment(2);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setBounds(0, 0, 0, 0);
        this.button.setFont(font.deriveFont(1));
        this.button.setContentAreaFilled(false);
        this.button.setHorizontalTextPosition(11);
        this.text.setMargin(new Insets(0, 13, 0, 0));
        this.text.setEditable(false);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setFont(font);
        this.rootPanel.setBackground(bg);
        this.rootPanel.setForeground(fg);
        for (int i = 0; i < this.rootPanel.getComponentCount(); ++i) {
            this.rootPanel.getComponent(i).setBackground(bg);
            this.rootPanel.getComponent(i).setForeground(fg);
        }
    }

    @Override
    public Component getComponent() {
        return this.rootPanel;
    }

    @Override
    public boolean isValueType() {
        return false;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public OutputInfoUnit getValue() {
        return null;
    }
}

