/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jcajce.provider.symmetric;

import org.openecard.bouncycastle.crypto.CipherKeyGenerator;
import org.openecard.bouncycastle.crypto.engines.SerpentEngine;
import org.openecard.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import org.openecard.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Serpent {
    private Serpent() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Serpent.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.Serpent", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.Serpent", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.Serpent", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Serpent IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Serpent", 192, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new SerpentEngine());
        }
    }
}

