/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openecard.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.params.DHParameters;
import org.openecard.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.openecard.bouncycastle.crypto.params.RSAKeyParameters;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.bouncycastle.crypto.tls.TlsClientContext;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsDHUtils;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsPSKIdentity;
import org.openecard.bouncycastle.crypto.tls.TlsRSAUtils;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.crypto.util.PublicKeyFactory;

class TlsPSKKeyExchange
implements TlsKeyExchange {
    protected TlsClientContext context;
    protected int keyExchange;
    protected TlsPSKIdentity pskIdentity;
    protected byte[] psk_identity_hint = null;
    protected DHPublicKeyParameters dhAgreeServerPublicKey = null;
    protected DHPrivateKeyParameters dhAgreeClientPrivateKey = null;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected RSAKeyParameters rsaServerPublicKey = null;
    protected byte[] premasterSecret;

    TlsPSKKeyExchange(TlsClientContext context, int keyExchange, TlsPSKIdentity pskIdentity) {
        switch (keyExchange) {
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.context = context;
        this.keyExchange = keyExchange;
        this.pskIdentity = pskIdentity;
    }

    @Override
    public void skipServerCertificate() throws IOException {
        if (this.keyExchange == 15) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange != 15) {
            throw new TlsFatalAlert(10);
        }
        org.openecard.bouncycastle.asn1.x509.Certificate x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43);
        }
        if (this.serverPublicKey.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        this.rsaServerPublicKey = this.validateRSAPublicKey((RSAKeyParameters)this.serverPublicKey);
        TlsUtils.validateKeyUsage(x509Cert, 32);
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        if (this.keyExchange == 14) {
            throw new TlsFatalAlert(10);
        }
        this.psk_identity_hint = new byte[0];
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        this.psk_identity_hint = TlsUtils.readOpaque16(is);
        if (this.keyExchange == 14) {
            byte[] pBytes = TlsUtils.readOpaque16(is);
            byte[] gBytes = TlsUtils.readOpaque16(is);
            byte[] YsBytes = TlsUtils.readOpaque16(is);
            BigInteger p = new BigInteger(1, pBytes);
            BigInteger g = new BigInteger(1, gBytes);
            BigInteger Ys = new BigInteger(1, YsBytes);
            this.dhAgreeServerPublicKey = TlsDHUtils.validateDHPublicKey(new DHPublicKeyParameters(Ys, new DHParameters(p, g)));
        } else if (this.psk_identity_hint.length == 0) {
            // empty if block
        }
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void skipClientCredentials() throws IOException {
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream os) throws IOException {
        if (this.psk_identity_hint == null || this.psk_identity_hint.length == 0) {
            this.pskIdentity.skipIdentityHint();
        } else {
            this.pskIdentity.notifyIdentityHint(this.psk_identity_hint);
        }
        byte[] psk_identity = this.pskIdentity.getPSKIdentity();
        TlsUtils.writeOpaque16(psk_identity, os);
        if (this.keyExchange == 15) {
            this.premasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.rsaServerPublicKey, os);
        } else if (this.keyExchange == 14) {
            this.dhAgreeClientPrivateKey = TlsDHUtils.generateEphemeralClientKeyExchange(this.context.getSecureRandom(), this.dhAgreeServerPublicKey.getParameters(), os);
        }
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        byte[] psk = this.pskIdentity.getPSK();
        byte[] other_secret = this.generateOtherSecret(psk.length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4 + other_secret.length + psk.length);
        TlsUtils.writeOpaque16(other_secret, buf);
        TlsUtils.writeOpaque16(psk, buf);
        return buf.toByteArray();
    }

    protected byte[] generateOtherSecret(int pskLength) {
        if (this.keyExchange == 14) {
            return TlsDHUtils.calculateDHBasicAgreement(this.dhAgreeServerPublicKey, this.dhAgreeClientPrivateKey);
        }
        if (this.keyExchange == 15) {
            return this.premasterSecret;
        }
        return new byte[pskLength];
    }

    protected RSAKeyParameters validateRSAPublicKey(RSAKeyParameters key) throws IOException {
        if (!key.getExponent().isProbablePrime(2)) {
            throw new TlsFatalAlert(47);
        }
        return key;
    }
}

