/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.modes;

import org.openecard.bouncycastle.crypto.BlockCipher;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.DataLengthException;
import org.openecard.bouncycastle.crypto.params.ParametersWithIV;

public class SICBlockCipher
implements BlockCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;

    public SICBlockCipher(BlockCipher c) {
        this.cipher = c;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            ParametersWithIV ivParam = (ParametersWithIV)params;
            byte[] iv = ivParam.getIV();
            System.arraycopy(iv, 0, this.IV, 0, this.IV.length);
            this.reset();
            if (ivParam.getParameters() != null) {
                this.cipher.init(true, ivParam.getParameters());
            }
        } else {
            throw new IllegalArgumentException("SIC mode requires ParametersWithIV");
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        for (int i = 0; i < this.counterOut.length; ++i) {
            out[outOff + i] = (byte)(this.counterOut[i] ^ in[inOff + i]);
        }
        int carry = 1;
        for (int i = this.counter.length - 1; i >= 0; --i) {
            int x = (this.counter[i] & 0xFF) + carry;
            carry = x > 255 ? 1 : 0;
            this.counter[i] = (byte)x;
        }
        return this.counter.length;
    }

    @Override
    public void reset() {
        System.arraycopy(this.IV, 0, this.counter, 0, this.counter.length);
        this.cipher.reset();
    }
}

