/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.anytype;

import iso.std.iso_iec._24727.tech.schema.DIDAbstractMarkerType;
import iso.std.iso_iec._24727.tech.schema.KeyRefType;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PasswordTypeType;
import iso.std.iso_iec._24727.tech.schema.PinCompareMarkerType;
import iso.std.iso_iec._24727.tech.schema.StateInfoType;
import java.math.BigInteger;
import java.util.Arrays;
import org.openecard.common.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PINCompareMarkerType {
    private KeyRefType pinRef = null;
    private String pinValue = null;
    private PasswordAttributesType passwordAttributes = null;
    private String protocol;

    public PINCompareMarkerType(DIDAbstractMarkerType didAbstractMarkerType) {
        if (!(didAbstractMarkerType instanceof PinCompareMarkerType)) {
            throw new IllegalArgumentException();
        }
        this.protocol = didAbstractMarkerType.getProtocol();
        for (Element e : didAbstractMarkerType.getAny()) {
            Node n;
            int i;
            NodeList nodeList;
            if (e.getLocalName().equals("PinRef")) {
                this.pinRef = new KeyRefType();
                nodeList = e.getChildNodes();
                for (i = 0; i < nodeList.getLength(); ++i) {
                    n = nodeList.item(i);
                    if (n.getLocalName().equals("KeyRef")) {
                        this.pinRef.setKeyRef(StringUtils.toByteArray(n.getTextContent()));
                        continue;
                    }
                    if (!n.getLocalName().equals("Protected")) continue;
                    this.pinRef.setProtected(Boolean.parseBoolean(n.getTextContent()));
                }
                continue;
            }
            if (e.getLocalName().equals("PinValue")) {
                this.pinValue = e.getTextContent();
                continue;
            }
            if (e.getLocalName().equals("PasswordAttributes")) {
                this.passwordAttributes = new PasswordAttributesType();
                nodeList = e.getChildNodes();
                for (i = 0; i < nodeList.getLength(); ++i) {
                    n = nodeList.item(i);
                    if (n.getLocalName().equals("pwdFlags")) {
                        this.passwordAttributes.getPwdFlags().addAll(Arrays.asList(n.getTextContent().split(" ")));
                        continue;
                    }
                    if (n.getLocalName().equals("pwdType")) {
                        this.passwordAttributes.setPwdType(PasswordTypeType.fromValue(n.getTextContent()));
                        continue;
                    }
                    if (n.getLocalName().equals("minLength")) {
                        this.passwordAttributes.setMinLength(new BigInteger(n.getTextContent()));
                        continue;
                    }
                    if (n.getLocalName().equals("maxLength")) {
                        this.passwordAttributes.setMaxLength(new BigInteger(n.getTextContent()));
                        continue;
                    }
                    if (n.getLocalName().equals("storedLength")) {
                        this.passwordAttributes.setStoredLength(new BigInteger(n.getTextContent()));
                        continue;
                    }
                    if (!n.getLocalName().equals("padChar")) continue;
                    this.passwordAttributes.setPadChar(StringUtils.toByteArray(n.getTextContent()));
                }
                continue;
            }
            if (!e.getLocalName().equals("StateInfo")) continue;
        }
    }

    public KeyRefType getPINRef() {
        return this.pinRef;
    }

    public String getPINValue() {
        return this.pinValue;
    }

    public PasswordAttributesType getPasswordAttributes() {
        return this.passwordAttributes;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public StateInfoType getStateInfo() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

