/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls;

import java.io.IOException;
import javax.annotation.Nullable;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.bouncycastle.crypto.tls.TlsAuthentication;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.crypto.tls.CertificateVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsNoAuthentication
implements TlsAuthentication {
    private static final Logger logger = LoggerFactory.getLogger(TlsNoAuthentication.class);
    private String hostname = null;
    private CertificateVerifier certVerifier = null;
    private Certificate lastCertChain;

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setCertificateVerifier(CertificateVerifier certVerifier) {
        this.certVerifier = certVerifier;
    }

    @Override
    public void notifyServerCertificate(Certificate crtfct) throws IOException {
        this.lastCertChain = crtfct;
        if (this.certVerifier != null) {
            if (this.hostname != null) {
                this.certVerifier.isValid(crtfct, this.hostname);
            } else {
                logger.warn("Hostname not available for certificate verification.");
                this.certVerifier.isValid(crtfct);
            }
        } else {
            logger.warn("No certificate verifier available, skipping certificate verification.");
        }
    }

    @Override
    public TlsCredentials getClientCredentials(CertificateRequest cr) throws IOException {
        String msg = "Client authentication is not supported with this implementation.";
        throw new UnsupportedOperationException(msg);
    }

    @Nullable
    public Certificate getServerCertificate() {
        return this.lastCertChain;
    }
}

