/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.openecard.common.apdu.ReadBinary;
import org.openecard.common.apdu.ReadRecord;
import org.openecard.common.apdu.Select;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.iso7816.DataElements;
import org.openecard.common.tlv.iso7816.FCP;
import org.openecard.common.util.ShortUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardUtils {
    private static final Logger logger = LoggerFactory.getLogger(CardUtils.class);
    private Dispatcher dispatcher;

    @Deprecated
    public CardUtils(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Deprecated
    public void selectMF(byte[] slotHandle) throws APDUException {
        Select.MasterFile selectMF = new Select.MasterFile();
        selectMF.transmit(this.dispatcher, slotHandle);
    }

    public static void selectMF(Dispatcher dispatcher, byte[] slotHandle) throws APDUException {
        Select.MasterFile selectMF = new Select.MasterFile();
        selectMF.transmit(dispatcher, slotHandle);
    }

    @Deprecated
    public void selectFile(byte[] slotHandle, short fileID) throws APDUException {
        Select.ChildFile selectFile = new Select.ChildFile(ShortUtils.toByteArray(fileID));
        selectFile.transmit(this.dispatcher, slotHandle);
    }

    public static void selectFile(Dispatcher dispatcher, byte[] slotHandle, short fileID) throws APDUException {
        CardUtils.selectFile(dispatcher, slotHandle, ShortUtils.toByteArray(fileID));
    }

    public static CardResponseAPDU selectFile(Dispatcher dispatcher, byte[] slotHandle, byte[] fileID) throws APDUException {
        Select.ChildFile selectFile = new Select.ChildFile(fileID);
        selectFile.setFCP();
        return selectFile.transmit(dispatcher, slotHandle);
    }

    @Deprecated
    public byte[] readFile(byte[] slotHandle, short fileID) throws Exception {
        CardResponseAPDU response;
        this.selectMF(slotHandle);
        this.selectFile(slotHandle, fileID);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte length = -1;
        int i = 0;
        do {
            ReadBinary readBinary = new ReadBinary((short)(i * (length & 0xFF)), length);
            response = readBinary.transmit(this.dispatcher, slotHandle);
            baos.write(response.getData());
            ++i;
        } while (response.isNormalProcessed());
        baos.close();
        return baos.toByteArray();
    }

    public static byte[] readFile(FCP fcp, Dispatcher dispatcher, byte[] slotHandle) throws APDUException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte length = -1;
        int i = 0;
        try {
            CardResponseAPDU response;
            do {
                if (!CardUtils.isRecordEF(fcp)) {
                    ReadBinary readBinary = new ReadBinary((short)(i * (length & 0xFF)), length);
                    response = readBinary.transmit(dispatcher, slotHandle);
                } else {
                    ReadRecord readRecord = new ReadRecord();
                    response = readRecord.transmit(dispatcher, slotHandle);
                }
                baos.write(response.getData());
                ++i;
            } while (response.isNormalProcessed());
            baos.close();
        }
        catch (IOException e) {
            throw new APDUException(e);
        }
        return baos.toByteArray();
    }

    public static byte[] readFile(Dispatcher dispatcher, byte[] slotHandle, short fileID) throws APDUException {
        return CardUtils.readFile(dispatcher, slotHandle, ShortUtils.toByteArray(fileID));
    }

    public static byte[] readFile(Dispatcher dispatcher, byte[] slotHandle, byte[] fileID) throws APDUException {
        CardResponseAPDU selectResponse = CardUtils.selectFile(dispatcher, slotHandle, fileID);
        FCP fcp = null;
        try {
            fcp = new FCP(selectResponse.getData());
        }
        catch (TLVException e) {
            logger.warn("Couldn't get File Control Parameters from Select response.", e);
        }
        return CardUtils.readFile(fcp, dispatcher, slotHandle);
    }

    private static boolean isRecordEF(FCP fcp) {
        if (fcp == null) {
            return false;
        }
        DataElements dataElements = fcp.getDataElements();
        return dataElements.isLinear() || dataElements.isCyclic();
    }
}

