/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.IOException;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.StreamCipher;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.crypto.tls.TlsCipher;
import org.openecard.bouncycastle.crypto.tls.TlsContext;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsMac;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.util.Arrays;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsStreamCipher(TlsContext context, StreamCipher clientWriteCipher, StreamCipher serverWriteCipher, Digest clientWriteDigest, Digest serverWriteDigest, int cipherKeySize) throws IOException {
        KeyParameter decryptParams;
        KeyParameter encryptParams;
        boolean isServer = context.isServer();
        this.context = context;
        this.encryptCipher = clientWriteCipher;
        this.decryptCipher = serverWriteCipher;
        int key_block_size = 2 * cipherKeySize + clientWriteDigest.getDigestSize() + serverWriteDigest.getDigestSize();
        byte[] key_block = TlsUtils.calculateKeyBlock(context, key_block_size);
        int offset = 0;
        TlsMac clientWriteMac = new TlsMac(context, clientWriteDigest, key_block, offset, clientWriteDigest.getDigestSize());
        TlsMac serverWriteMac = new TlsMac(context, serverWriteDigest, key_block, offset += clientWriteDigest.getDigestSize(), serverWriteDigest.getDigestSize());
        KeyParameter clientWriteKey = new KeyParameter(key_block, offset += serverWriteDigest.getDigestSize(), cipherKeySize);
        KeyParameter serverWriteKey = new KeyParameter(key_block, offset += cipherKeySize, cipherKeySize);
        if ((offset += cipherKeySize) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (isServer) {
            this.writeMac = serverWriteMac;
            this.readMac = clientWriteMac;
            this.encryptCipher = serverWriteCipher;
            this.decryptCipher = clientWriteCipher;
            encryptParams = serverWriteKey;
            decryptParams = clientWriteKey;
        } else {
            this.writeMac = clientWriteMac;
            this.readMac = serverWriteMac;
            this.encryptCipher = clientWriteCipher;
            this.decryptCipher = serverWriteCipher;
            encryptParams = clientWriteKey;
            decryptParams = serverWriteKey;
        }
        this.encryptCipher.init(true, encryptParams);
        this.decryptCipher.init(false, decryptParams);
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.writeMac.getSize();
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) {
        byte[] mac = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
        byte[] outbuf = new byte[len + mac.length];
        this.encryptCipher.processBytes(plaintext, offset, len, outbuf, 0);
        this.encryptCipher.processBytes(mac, 0, mac.length, outbuf, len);
        return outbuf;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        int macSize = this.readMac.getSize();
        if (len < macSize) {
            throw new TlsFatalAlert(50);
        }
        byte[] deciphered = new byte[len];
        this.decryptCipher.processBytes(ciphertext, offset, len, deciphered, 0);
        int macInputLen = len - macSize;
        byte[] receivedMac = Arrays.copyOfRange(deciphered, macInputLen, len);
        byte[] computedMac = this.readMac.calculateMac(seqNo, type, deciphered, 0, macInputLen);
        if (!Arrays.constantTimeAreEqual(receivedMac, computedMac)) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(deciphered, 0, macInputLen);
    }
}

