/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.engines;

import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.DataLengthException;
import org.openecard.bouncycastle.crypto.MaxBytesExceededException;
import org.openecard.bouncycastle.crypto.OutputLengthException;
import org.openecard.bouncycastle.crypto.StreamCipher;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.crypto.params.ParametersWithIV;
import org.openecard.bouncycastle.crypto.util.Pack;
import org.openecard.bouncycastle.util.Strings;

public class Salsa20Engine
implements StreamCipher {
    private static final int STATE_SIZE = 16;
    private static final byte[] sigma = Strings.toByteArray("expand 32-byte k");
    private static final byte[] tau = Strings.toByteArray("expand 16-byte k");
    private int index = 0;
    private int[] engineState = new int[16];
    private int[] x = new int[16];
    private byte[] keyStream = new byte[64];
    private byte[] workingKey = null;
    private byte[] workingIV = null;
    private boolean initialised = false;
    private int cW0;
    private int cW1;
    private int cW2;

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Salsa20 Init parameters must include an IV");
        }
        ParametersWithIV ivParams = (ParametersWithIV)params;
        byte[] iv = ivParams.getIV();
        if (iv == null || iv.length != 8) {
            throw new IllegalArgumentException("Salsa20 requires exactly 8 bytes of IV");
        }
        if (!(ivParams.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException("Salsa20 Init parameters must include a key");
        }
        KeyParameter key = (KeyParameter)ivParams.getParameters();
        this.workingKey = key.getKey();
        this.workingIV = iv;
        this.setKey(this.workingKey, this.workingIV);
    }

    @Override
    public String getAlgorithmName() {
        return "Salsa20";
    }

    @Override
    public byte returnByte(byte in) {
        if (this.limitExceeded()) {
            throw new MaxBytesExceededException("2^70 byte limit per IV; Change IV");
        }
        if (this.index == 0) {
            this.generateKeyStream(this.keyStream);
            this.engineState[8] = this.engineState[8] + 1;
            if (this.engineState[8] == 0) {
                this.engineState[9] = this.engineState[9] + 1;
            }
        }
        byte out = (byte)(this.keyStream[this.index] ^ in);
        this.index = this.index + 1 & 0x3F;
        return out;
    }

    @Override
    public void processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.limitExceeded(len)) {
            throw new MaxBytesExceededException("2^70 byte limit per IV would be exceeded; Change IV");
        }
        for (int i = 0; i < len; ++i) {
            if (this.index == 0) {
                this.generateKeyStream(this.keyStream);
                this.engineState[8] = this.engineState[8] + 1;
                if (this.engineState[8] == 0) {
                    this.engineState[9] = this.engineState[9] + 1;
                }
            }
            out[i + outOff] = (byte)(this.keyStream[this.index] ^ in[i + inOff]);
            this.index = this.index + 1 & 0x3F;
        }
    }

    @Override
    public void reset() {
        this.setKey(this.workingKey, this.workingIV);
    }

    private void setKey(byte[] keyBytes, byte[] ivBytes) {
        byte[] constants;
        this.workingKey = keyBytes;
        this.workingIV = ivBytes;
        this.index = 0;
        this.resetCounter();
        int offset = 0;
        this.engineState[1] = Pack.littleEndianToInt(this.workingKey, 0);
        this.engineState[2] = Pack.littleEndianToInt(this.workingKey, 4);
        this.engineState[3] = Pack.littleEndianToInt(this.workingKey, 8);
        this.engineState[4] = Pack.littleEndianToInt(this.workingKey, 12);
        if (this.workingKey.length == 32) {
            constants = sigma;
            offset = 16;
        } else {
            constants = tau;
        }
        this.engineState[11] = Pack.littleEndianToInt(this.workingKey, offset);
        this.engineState[12] = Pack.littleEndianToInt(this.workingKey, offset + 4);
        this.engineState[13] = Pack.littleEndianToInt(this.workingKey, offset + 8);
        this.engineState[14] = Pack.littleEndianToInt(this.workingKey, offset + 12);
        this.engineState[0] = Pack.littleEndianToInt(constants, 0);
        this.engineState[5] = Pack.littleEndianToInt(constants, 4);
        this.engineState[10] = Pack.littleEndianToInt(constants, 8);
        this.engineState[15] = Pack.littleEndianToInt(constants, 12);
        this.engineState[6] = Pack.littleEndianToInt(this.workingIV, 0);
        this.engineState[7] = Pack.littleEndianToInt(this.workingIV, 4);
        this.engineState[9] = 0;
        this.engineState[8] = 0;
        this.initialised = true;
    }

    private void generateKeyStream(byte[] output) {
        Salsa20Engine.salsaCore(20, this.engineState, this.x);
        Pack.intToLittleEndian(this.x, output, 0);
    }

    public static void salsaCore(int rounds, int[] input, int[] x) {
        int i;
        System.arraycopy(input, 0, x, 0, input.length);
        for (i = rounds; i > 0; i -= 2) {
            x[4] = x[4] ^ Salsa20Engine.rotl(x[0] + x[12], 7);
            x[8] = x[8] ^ Salsa20Engine.rotl(x[4] + x[0], 9);
            x[12] = x[12] ^ Salsa20Engine.rotl(x[8] + x[4], 13);
            x[0] = x[0] ^ Salsa20Engine.rotl(x[12] + x[8], 18);
            x[9] = x[9] ^ Salsa20Engine.rotl(x[5] + x[1], 7);
            x[13] = x[13] ^ Salsa20Engine.rotl(x[9] + x[5], 9);
            x[1] = x[1] ^ Salsa20Engine.rotl(x[13] + x[9], 13);
            x[5] = x[5] ^ Salsa20Engine.rotl(x[1] + x[13], 18);
            x[14] = x[14] ^ Salsa20Engine.rotl(x[10] + x[6], 7);
            x[2] = x[2] ^ Salsa20Engine.rotl(x[14] + x[10], 9);
            x[6] = x[6] ^ Salsa20Engine.rotl(x[2] + x[14], 13);
            x[10] = x[10] ^ Salsa20Engine.rotl(x[6] + x[2], 18);
            x[3] = x[3] ^ Salsa20Engine.rotl(x[15] + x[11], 7);
            x[7] = x[7] ^ Salsa20Engine.rotl(x[3] + x[15], 9);
            x[11] = x[11] ^ Salsa20Engine.rotl(x[7] + x[3], 13);
            x[15] = x[15] ^ Salsa20Engine.rotl(x[11] + x[7], 18);
            x[1] = x[1] ^ Salsa20Engine.rotl(x[0] + x[3], 7);
            x[2] = x[2] ^ Salsa20Engine.rotl(x[1] + x[0], 9);
            x[3] = x[3] ^ Salsa20Engine.rotl(x[2] + x[1], 13);
            x[0] = x[0] ^ Salsa20Engine.rotl(x[3] + x[2], 18);
            x[6] = x[6] ^ Salsa20Engine.rotl(x[5] + x[4], 7);
            x[7] = x[7] ^ Salsa20Engine.rotl(x[6] + x[5], 9);
            x[4] = x[4] ^ Salsa20Engine.rotl(x[7] + x[6], 13);
            x[5] = x[5] ^ Salsa20Engine.rotl(x[4] + x[7], 18);
            x[11] = x[11] ^ Salsa20Engine.rotl(x[10] + x[9], 7);
            x[8] = x[8] ^ Salsa20Engine.rotl(x[11] + x[10], 9);
            x[9] = x[9] ^ Salsa20Engine.rotl(x[8] + x[11], 13);
            x[10] = x[10] ^ Salsa20Engine.rotl(x[9] + x[8], 18);
            x[12] = x[12] ^ Salsa20Engine.rotl(x[15] + x[14], 7);
            x[13] = x[13] ^ Salsa20Engine.rotl(x[12] + x[15], 9);
            x[14] = x[14] ^ Salsa20Engine.rotl(x[13] + x[12], 13);
            x[15] = x[15] ^ Salsa20Engine.rotl(x[14] + x[13], 18);
        }
        for (i = 0; i < 16; ++i) {
            int n = i;
            x[n] = x[n] + input[i];
        }
    }

    private static int rotl(int x, int y) {
        return x << y | x >>> -y;
    }

    private void resetCounter() {
        this.cW0 = 0;
        this.cW1 = 0;
        this.cW2 = 0;
    }

    private boolean limitExceeded() {
        if (++this.cW0 == 0 && ++this.cW1 == 0) {
            return (++this.cW2 & 0x20) != 0;
        }
        return false;
    }

    private boolean limitExceeded(int len) {
        this.cW0 += len;
        if (this.cW0 < len && this.cW0 >= 0 && ++this.cW1 == 0) {
            return (++this.cW2 & 0x20) != 0;
        }
        return false;
    }
}

