/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.asn1;

import java.io.IOException;
import org.openecard.bouncycastle.asn1.ASN1OctetString;
import org.openecard.bouncycastle.asn1.ASN1OutputStream;
import org.openecard.bouncycastle.asn1.ASN1Primitive;
import org.openecard.bouncycastle.asn1.ASN1String;
import org.openecard.bouncycastle.asn1.ASN1TaggedObject;
import org.openecard.bouncycastle.asn1.StreamUtil;
import org.openecard.bouncycastle.util.Arrays;

public class DERBMPString
extends ASN1Primitive
implements ASN1String {
    private char[] string;

    public static DERBMPString getInstance(Object obj) {
        if (obj == null || obj instanceof DERBMPString) {
            return (DERBMPString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERBMPString)DERBMPString.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERBMPString) {
            return DERBMPString.getInstance(o);
        }
        return new DERBMPString(ASN1OctetString.getInstance(o).getOctets());
    }

    DERBMPString(byte[] string) {
        char[] cs = new char[string.length / 2];
        for (int i = 0; i != cs.length; ++i) {
            cs[i] = (char)(string[2 * i] << 8 | string[2 * i + 1] & 0xFF);
        }
        this.string = cs;
    }

    DERBMPString(char[] string) {
        this.string = string;
    }

    public DERBMPString(String string) {
        this.string = string.toCharArray();
    }

    @Override
    public String getString() {
        return new String(this.string);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERBMPString)) {
            return false;
        }
        DERBMPString s = (DERBMPString)o;
        return Arrays.areEqual(this.string, s.string);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length * 2) + this.string.length * 2;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.write(30);
        out.writeLength(this.string.length * 2);
        for (int i = 0; i != this.string.length; ++i) {
            char c = this.string[i];
            out.write((byte)(c >> 8));
            out.write((byte)c);
        }
    }
}

