/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.openecard.bouncycastle.crypto.engines.AESFastEngine;
import org.openecard.bouncycastle.crypto.macs.CMac;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.tlv.TLV;
import org.openecard.common.util.ByteUtils;

public class SecureMessaging {
    private static final byte[] NULL = new byte[]{0};
    private static final byte PAD = -128;
    private byte[] secureMessagingSSC;
    private byte[] keyMAC;
    private byte[] keyENC;

    public SecureMessaging(byte[] keyMAC, byte[] keyENC) {
        this.keyENC = keyENC;
        this.keyMAC = keyMAC;
        this.secureMessagingSSC = new byte[16];
    }

    public byte[] encrypt(byte[] apdu) throws Exception {
        SecureMessaging.incrementSSC(this.secureMessagingSSC);
        byte[] commandAPDU = this.encrypt(apdu, this.secureMessagingSSC);
        SecureMessaging.incrementSSC(this.secureMessagingSSC);
        return commandAPDU;
    }

    private byte[] encrypt(byte[] apdu, byte[] secureMessagingSSC) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CardCommandAPDU cAPDU = new CardCommandAPDU(apdu);
        if (cAPDU.isSecureMessaging()) {
            throw new IllegalArgumentException("Malformed APDU.");
        }
        byte[] data = cAPDU.getData();
        byte[] header = cAPDU.getHeader();
        int lc = cAPDU.getLC();
        int le = cAPDU.getLE();
        if (data != null) {
            data = this.pad(data, 16);
            Cipher c = this.getCipher(secureMessagingSSC, 1);
            byte[] dataEncrypted = c.doFinal(data);
            dataEncrypted = ByteUtils.concatenate((byte)1, dataEncrypted);
            TLV dataObject = new TLV();
            dataObject.setTagNumWithClass((byte)-121);
            dataObject.setValue(dataEncrypted);
            baos.write(dataObject.toBER());
        }
        if (le >= 0) {
            TLV leObject = new TLV();
            leObject.setTagNumWithClass((byte)-105);
            if (le == 256) {
                leObject.setValue(NULL);
            } else if (le > 256) {
                leObject.setValue(new byte[]{(byte)(le >> 8 & 0xFF), (byte)(le & 0xFF)});
            } else {
                leObject.setValue(new byte[]{(byte)le});
            }
            baos.write(leObject.toBER());
        }
        header[0] = (byte)(header[0] | 0xC);
        byte[] mac = new byte[16];
        CMac cmac = this.getCMAC(secureMessagingSSC);
        byte[] paddedHeader = this.pad(header, 16);
        cmac.update(paddedHeader, 0, paddedHeader.length);
        if (baos.size() > 0) {
            byte[] paddedData = this.pad(baos.toByteArray(), 16);
            cmac.update(paddedData, 0, paddedData.length);
            lc = baos.size();
        }
        cmac.doFinal(mac, 0);
        mac = ByteUtils.copy(mac, 0, 8);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(header);
        if ((lc += 10) > 255 || le > 256) {
            out.write(NULL);
            out.write(lc >> 8 & 0xFF);
            out.write(lc & 0xFF);
        } else {
            out.write(lc & 0xFF);
        }
        if (baos.size() > 0) {
            out.write(baos.toByteArray());
        }
        out.write(new byte[]{-114, 8});
        out.write(mac);
        out.write(NULL);
        if (lc > 255 || le > 256) {
            out.write(NULL);
        }
        return out.toByteArray();
    }

    public byte[] decrypt(byte[] response) throws Exception {
        if (response.length < 12) {
            throw new IllegalArgumentException("Malformed Secure Messaging APDU");
        }
        return this.decrypt(response, this.secureMessagingSSC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decrypt(byte[] response, byte[] secureMessagingSSC) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(response);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(response.length - 10);
        byte[] statusBytes = new byte[2];
        byte[] dataObject = null;
        byte[] macObject = new byte[8];
        byte tag = (byte)bais.read();
        if (tag == -121) {
            int size = bais.read();
            if (size > 128) {
                byte[] sizeBytes = new byte[size & 0xF];
                bais.read(sizeBytes, 0, sizeBytes.length);
                size = new BigInteger(1, sizeBytes).intValue();
            }
            bais.skip(1L);
            dataObject = new byte[size - 1];
            bais.read(dataObject, 0, dataObject.length);
            tag = (byte)bais.read();
        }
        if (tag == -103) {
            if (bais.read() == 2) {
                bais.read(statusBytes, 0, 2);
                tag = (byte)bais.read();
            }
        } else {
            throw new IOException("Malformed Secure Messaging APDU");
        }
        if (tag == -114) {
            if (bais.read() == 8) {
                bais.read(macObject, 0, 8);
            }
        } else {
            throw new IOException("Malformed Secure Messaging APDU");
        }
        if (bais.available() != 2) {
            throw new IOException("Malformed Secure Messaging APDU");
        }
        CMac cmac = this.getCMAC(secureMessagingSSC);
        byte[] mac = new byte[16];
        CMac cMac = cmac;
        synchronized (cMac) {
            ByteArrayOutputStream macData = new ByteArrayOutputStream();
            if (dataObject != null) {
                TLV paddedDataObject = new TLV();
                paddedDataObject.setTagNumWithClass((byte)-121);
                paddedDataObject.setValue(ByteUtils.concatenate((byte)1, dataObject));
                macData.write(paddedDataObject.toBER());
            }
            TLV statusBytesObject = new TLV();
            statusBytesObject.setTagNumWithClass((byte)-103);
            statusBytesObject.setValue(statusBytes);
            macData.write(statusBytesObject.toBER());
            byte[] paddedData = this.pad(macData.toByteArray(), 16);
            cmac.update(paddedData, 0, paddedData.length);
            cmac.doFinal(mac, 0);
            mac = ByteUtils.copy(mac, 0, 8);
        }
        if (!ByteUtils.compare(mac, macObject)) {
            throw new GeneralSecurityException("Secure Messaging MAC verification failed");
        }
        if (dataObject != null) {
            Cipher c = this.getCipher(secureMessagingSSC, 2);
            byte[] data_decrypted = c.doFinal(dataObject);
            baos.write(this.unpad(data_decrypted));
        }
        baos.write(statusBytes);
        return baos.toByteArray();
    }

    public static void incrementSSC(byte[] ssc) {
        for (int i = ssc.length - 1; i >= 0; --i) {
            int n = i;
            ssc[n] = (byte)(ssc[n] + 1);
            if (ssc[i] != 0) break;
        }
    }

    private Cipher getCipher(byte[] smssc, int mode) throws Exception {
        Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
        SecretKeySpec key = new SecretKeySpec(this.keyENC, "AES");
        byte[] iv = this.getCipherIV(smssc);
        IvParameterSpec algoPara = new IvParameterSpec(iv);
        c.init(mode, (Key)key, algoPara);
        return c;
    }

    private byte[] getCipherIV(byte[] smssc) throws Exception {
        Cipher c = Cipher.getInstance("AES/ECB/NoPadding");
        SecretKeySpec key = new SecretKeySpec(this.keyENC, "AES");
        c.init(1, key);
        return c.doFinal(smssc);
    }

    private CMac getCMAC(byte[] smssc) {
        CMac cmac = new CMac(new AESFastEngine());
        cmac.init(new KeyParameter(this.keyMAC));
        cmac.update(smssc, 0, smssc.length);
        return cmac;
    }

    private byte[] pad(byte[] data, int blockSize) {
        byte[] result = new byte[data.length + (blockSize - data.length % blockSize)];
        System.arraycopy(data, 0, result, 0, data.length);
        result[data.length] = -128;
        return result;
    }

    private byte[] unpad(byte[] data) {
        for (int i = data.length - 1; i >= 0; --i) {
            if (data[i] != -128) continue;
            return ByteUtils.copy(data, 0, i);
        }
        return data;
    }
}

