/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.Mac;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.util.Arrays;

public class SSL3Mac
implements Mac {
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    static final byte[] MD5_IPAD = SSL3Mac.genPad((byte)54, 48);
    static final byte[] MD5_OPAD = SSL3Mac.genPad((byte)92, 48);
    static final byte[] SHA1_IPAD = SSL3Mac.genPad((byte)54, 40);
    static final byte[] SHA1_OPAD = SSL3Mac.genPad((byte)92, 40);
    private Digest digest;
    private byte[] secret;
    private byte[] ipad;
    private byte[] opad;

    public SSL3Mac(Digest digest) {
        this.digest = digest;
        if (digest.getDigestSize() == 20) {
            this.ipad = SHA1_IPAD;
            this.opad = SHA1_OPAD;
        } else {
            this.ipad = MD5_IPAD;
            this.opad = MD5_OPAD;
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "/SSL3MAC";
    }

    public Digest getUnderlyingDigest() {
        return this.digest;
    }

    @Override
    public void init(CipherParameters params) {
        this.secret = Arrays.clone(((KeyParameter)params).getKey());
        this.reset();
    }

    @Override
    public int getMacSize() {
        return this.digest.getDigestSize();
    }

    @Override
    public void update(byte in) {
        this.digest.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(tmp, 0);
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(this.opad, 0, this.opad.length);
        this.digest.update(tmp, 0, tmp.length);
        int len = this.digest.doFinal(out, outOff);
        this.reset();
        return len;
    }

    @Override
    public void reset() {
        this.digest.reset();
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(this.ipad, 0, this.ipad.length);
    }

    private static byte[] genPad(byte b, int count) {
        byte[] padding = new byte[count];
        Arrays.fill(padding, b);
        return padding;
    }
}

