/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsClient;
import org.openecard.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import org.openecard.bouncycastle.crypto.tls.TlsCipher;
import org.openecard.bouncycastle.crypto.tls.TlsCipherFactory;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsSRPKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.util.Arrays;

public abstract class SRPTlsClient
extends AbstractTlsClient {
    public static final Integer EXT_SRP = new Integer(12);
    protected TlsCipherFactory cipherFactory;
    protected byte[] identity;
    protected byte[] password;

    public SRPTlsClient(byte[] identity, byte[] password, String fqdn) {
        this(new DefaultTlsCipherFactory(), identity, password, fqdn);
    }

    public SRPTlsClient(TlsCipherFactory cipherFactory, byte[] identity, byte[] password, String fqdn) {
        super(fqdn);
        this.cipherFactory = cipherFactory;
        this.identity = Arrays.clone(identity);
        this.password = Arrays.clone(password);
        ByteArrayOutputStream srpData = new ByteArrayOutputStream();
        try {
            TlsUtils.writeOpaque8(this.identity, srpData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addClientExtension(EXT_SRP, srpData.toByteArray());
    }

    public static int[] getDefaultCipherSuites() {
        return new int[]{49186, 49183, 49180, 49185, 49182, 49179, 49184, 49181, 49178};
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49186, 49183, 49180, 49185, 49182, 49179, 49184, 49181, 49178};
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) {
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49181: 
            case 49184: {
                return this.createSRPKeyExchange(21);
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.createSRPKeyExchange(23);
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.createSRPKeyExchange(22);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49179: 
            case 49180: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 49181: 
            case 49182: 
            case 49183: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 49184: 
            case 49185: 
            case 49186: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int keyExchange) {
        return new TlsSRPKeyExchange(this.context, keyExchange, this.identity, this.password);
    }
}

