/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.openecard.gui.definition.BoxItem;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.swing.components.CheckBoxItem;
import org.openecard.gui.swing.components.StepComponent;

public class Checkbox
implements StepComponent {
    private final org.openecard.gui.definition.Checkbox result;
    private final ArrayList<JCheckBox> boxButtons;
    private final List<BoxItem> defaultCheckbox;
    private final JPanel panel;
    JPanel contentPanel = new JPanel();

    public Checkbox(org.openecard.gui.definition.Checkbox checkbox) {
        this.result = new org.openecard.gui.definition.Checkbox(checkbox.getID());
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridLayout layout = new GridLayout(0, 2);
        this.contentPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        int alternate = 0;
        this.boxButtons = new ArrayList(checkbox.getBoxItems().size());
        this.defaultCheckbox = checkbox.getBoxItems();
        for (BoxItem next : checkbox.getBoxItems()) {
            BoxItem copy = new BoxItem();
            this.result.getBoxItems().add(copy);
            copy.setName(next.getName());
            copy.setText(next.getText());
            copy.setDisabled(next.isDisabled());
            CheckBoxItem component = new CheckBoxItem(next.getText() == null ? "" : next.getText(), next.isChecked());
            if (next.isDisabled()) {
                component.setEnabled(false);
            }
            if (next.isChecked()) {
                component.setSelected(true);
            }
            component.setBackground(Color.WHITE);
            c.fill = 2;
            c.gridx = alternate;
            c.gridy = -1;
            alternate ^= 1;
            this.contentPanel.add(component);
            this.boxButtons.add(component);
        }
        this.panel.add((Component)this.contentPanel, "Center");
    }

    public void resetSelection() {
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            JCheckBox b = (JCheckBox)this.contentPanel.getComponent(i);
            for (int j = 0; j < this.defaultCheckbox.size(); ++j) {
                if (!b.getName().equals(this.defaultCheckbox.get(j).getName())) continue;
                b.setSelected(this.defaultCheckbox.get(j).isChecked());
            }
        }
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public boolean isValueType() {
        return true;
    }

    @Override
    public OutputInfoUnit getValue() {
        for (int i = 0; i < this.boxButtons.size(); ++i) {
            JCheckBox component = this.boxButtons.get(i);
            this.result.getBoxItems().get(i).setChecked(component.isSelected());
        }
        return this.result;
    }
}

