/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1Integer;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.crypto.common.asn1.eac.FileID;
import org.openecard.crypto.common.asn1.eac.SecurityInfo;

public final class TAInfo
extends SecurityInfo {
    private String protocol = this.getIdentifier();
    private int version = ((ASN1Integer)this.getRequiredData()).getValue().intValue();
    private FileID efCVCA;
    private static final String[] protocols = new String[]{"0.4.0.127.0.7.2.2.2.2.1", "0.4.0.127.0.7.2.2.2.2.2", "0.4.0.127.0.7.2.2.2.2.3", "0.4.0.127.0.7.2.2.2.2.4", "0.4.0.127.0.7.2.2.2.2.5", "0.4.0.127.0.7.2.2.2.1.3", "0.4.0.127.0.7.2.2.2.1.4", "0.4.0.127.0.7.2.2.2.1.6", "0.4.0.127.0.7.2.2.2.1.1", "0.4.0.127.0.7.2.2.2.1.2", "0.4.0.127.0.7.2.2.2.1.5"};

    public TAInfo(ASN1Sequence seq) {
        super(seq);
        if (seq.size() == 3) {
            this.efCVCA = FileID.getInstance(this.getOptionalData());
        }
    }

    public boolean isECDSA() {
        return this.protocol.startsWith("0.4.0.127.0.7.2.2.2.2");
    }

    public boolean isRSA() {
        return this.protocol.startsWith("0.4.0.127.0.7.2.2.2.1");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getVersion() {
        return this.version;
    }

    public FileID getEFCVCA() {
        return this.efCVCA;
    }

    public static boolean isObjectIdentifier(String oid) {
        for (int i = 0; i < protocols.length; ++i) {
            if (!protocols[i].equals(oid)) continue;
            return true;
        }
        return false;
    }
}

