/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import generated.TCTokenType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.StartPAOS;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsClient;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.util.HttpRequestLineUtils;
import org.openecard.control.module.tctoken.TCTokenException;
import org.openecard.control.module.tctoken.TCTokenFactory;
import org.openecard.control.module.tctoken.TCTokenRequest;
import org.openecard.control.module.tctoken.TCTokenResponse;
import org.openecard.control.module.tctoken.gui.InsertCardDialog;
import org.openecard.crypto.tls.ClientCertDefaultTlsClient;
import org.openecard.crypto.tls.ClientCertPSKTlsClient;
import org.openecard.crypto.tls.TlsNoAuthentication;
import org.openecard.crypto.tls.TlsPSKIdentityImpl;
import org.openecard.gui.UserConsent;
import org.openecard.recognition.CardRecognition;
import org.openecard.transport.paos.PAOS;
import org.openecard.transport.paos.PAOSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTCTokenHandler {
    private static final Logger logger = LoggerFactory.getLogger(GenericTCTokenHandler.class);
    private final CardStateMap cardStates;
    private final Dispatcher dispatcher;
    private final UserConsent gui;
    private final CardRecognition rec;

    public GenericTCTokenHandler(CardStateMap cardStates, Dispatcher dispatcher, UserConsent gui, CardRecognition rec) {
        this.cardStates = cardStates;
        this.dispatcher = dispatcher;
        this.gui = gui;
        this.rec = rec;
    }

    public TCTokenRequest parseTCTokenRequestURI(URI requestURI) throws UnsupportedEncodingException, TCTokenException {
        TCTokenRequest tcTokenRequest = new TCTokenRequest();
        String queryStr = requestURI.getRawQuery();
        Map<String, String> queries = HttpRequestLineUtils.transform(queryStr);
        for (Map.Entry<String, String> next : queries.entrySet()) {
            String k = next.getKey();
            String v = next.getValue();
            if (k.equals("tcTokenURL")) {
                if (v != null && !v.isEmpty()) {
                    try {
                        TCTokenType token = TCTokenFactory.generateTCToken(new URL(v));
                        tcTokenRequest.setTCToken(token);
                        continue;
                    }
                    catch (MalformedURLException ex) {
                        String msg = "The tcTokenURL parameter contains an invalid URL: " + v;
                        throw new TCTokenException(msg, ex);
                    }
                }
                throw new TCTokenException("Parameter tcTokenURL contains no value.");
            }
            if (k.equals("ifdName")) {
                if (v != null && !v.isEmpty()) {
                    tcTokenRequest.setIFDName(v);
                    continue;
                }
                throw new TCTokenException("Parameter ifdName contains no value.");
            }
            if (k.equals("contextHandle")) {
                if (v != null && !v.isEmpty()) {
                    tcTokenRequest.setContextHandle(v);
                    continue;
                }
                throw new TCTokenException("Parameter contextHandle contains no value.");
            }
            if (k.equals("slotIndex")) {
                if (v != null && !v.isEmpty()) {
                    tcTokenRequest.setSlotIndex(v);
                    continue;
                }
                throw new TCTokenException("Parameter slotIndex contains no value.");
            }
            if (k.equals("cardType")) {
                if (v != null && !v.isEmpty()) {
                    tcTokenRequest.setCardType(v);
                    continue;
                }
                throw new TCTokenException("Parameter cardType contains no value.");
            }
            logger.info("Unknown query element: {}", (Object)k);
        }
        return tcTokenRequest;
    }

    private ConnectionHandleType getFirstHandle(String type) {
        String cardName = this.rec.getTranslatedCardName(type);
        ConnectionHandleType conHandle = new ConnectionHandleType();
        ConnectionHandleType.RecognitionInfo recInfo = new ConnectionHandleType.RecognitionInfo();
        recInfo.setCardType(type);
        conHandle.setRecognitionInfo(recInfo);
        Set<CardStateEntry> entries = this.cardStates.getMatchingEntries(conHandle);
        if (entries.isEmpty()) {
            InsertCardDialog uc = new InsertCardDialog(this.gui, this.cardStates, type, cardName);
            return uc.show();
        }
        return entries.iterator().next().handleCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCTokenResponse doPAOS(TCTokenType token, ConnectionHandleType connectionHandle) throws PAOSException, DispatcherException {
        CardApplicationDisconnect appDis;
        TCTokenResponse tCTokenResponse;
        CardApplicationPath appPath = new CardApplicationPath();
        appPath.setCardAppPathRequest(connectionHandle);
        CardApplicationPathResponse appPathRes = (CardApplicationPathResponse)this.dispatcher.deliver(appPath);
        WSHelper.checkResult(appPathRes);
        CardApplicationConnect appConnect = new CardApplicationConnect();
        List<CardApplicationPathType> pathRes = appPathRes.getCardAppPathResultSet().getCardApplicationPathResult();
        appConnect.setCardApplicationPath(pathRes.get(0));
        CardApplicationConnectResponse appConnectRes = (CardApplicationConnectResponse)this.dispatcher.deliver(appConnect);
        connectionHandle = appConnectRes.getConnectionHandle();
        WSHelper.checkResult(appConnectRes);
        try {
            AbstractTlsClient tlsClient;
            TlsNoAuthentication tlsAuth;
            String sessionIdentifier = token.getSessionIdentifier();
            URL serverAddress = new URL(token.getServerAddress());
            String serverHost = serverAddress.getHost();
            String secProto = token.getPathSecurityProtocol();
            String queryPart = serverAddress.getQuery();
            if (queryPart == null || !queryPart.contains("?sessionid=") && !queryPart.contains("&sessionid=")) {
                String sAddr = serverAddress.toString();
                sAddr = sAddr.endsWith("?") ? sAddr + "sessionid=" + sessionIdentifier : (sAddr.contains("?") ? sAddr + "&sessionid=" + sessionIdentifier : sAddr + "?sessionid=" + sessionIdentifier);
                serverAddress = new URL(sAddr);
            }
            if (secProto.equals("urn:ietf:rfc:4279") || secProto.equals("urn:ietf:rfc:5487")) {
                tlsAuth = new TlsNoAuthentication();
                tlsAuth.setHostname(serverHost);
                byte[] psk = token.getPathSecurityParameters().getPSK();
                TlsPSKIdentityImpl pskId = new TlsPSKIdentityImpl(sessionIdentifier.getBytes(), psk);
                tlsClient = new ClientCertPSKTlsClient(pskId, serverHost);
                tlsClient.setAuthentication(tlsAuth);
                tlsClient.setClientVersion(ProtocolVersion.TLSv11);
            } else if (secProto.equals("urn:ietf:rfc:4346")) {
                tlsAuth = new TlsNoAuthentication();
                tlsAuth.setHostname(serverHost);
                tlsClient = new ClientCertDefaultTlsClient(serverHost);
                tlsClient.setAuthentication(tlsAuth);
                tlsClient.setClientVersion(ProtocolVersion.TLSv11);
            } else {
                throw new PAOSException("Unknow security protocol '" + secProto + "' requested.");
            }
            if (serverAddress.getProtocol().equals("http")) {
                tlsClient = null;
            }
            PAOS p = new PAOS(serverAddress, this.dispatcher, tlsClient);
            StartPAOS sp = new StartPAOS();
            sp.setProfile("http://www.bsi.bund.de/ecard/api/1.1");
            sp.getConnectionHandle().add(connectionHandle);
            sp.setSessionIdentifier(sessionIdentifier);
            p.sendStartPAOS(sp);
            TCTokenResponse response = new TCTokenResponse();
            response.setRefreshAddress(new URL(token.getRefreshAddress()));
            response.setResult(WSHelper.makeResultOK());
            tCTokenResponse = response;
            appDis = new CardApplicationDisconnect();
            appDis.setConnectionHandle(connectionHandle);
        }
        catch (Throwable throwable) {
            try {
                CardApplicationDisconnect appDis2 = new CardApplicationDisconnect();
                appDis2.setConnectionHandle(connectionHandle);
                this.dispatcher.deliver(appDis2);
                throw throwable;
            }
            catch (WSHelper.WSException ex) {
                throw new DispatcherException("Failed to connect to card.", ex);
            }
            catch (InvocationTargetException ex) {
                throw new DispatcherException(ex);
            }
            catch (MalformedURLException ex) {
                throw new PAOSException(ex);
            }
        }
        this.dispatcher.deliver(appDis);
        return tCTokenResponse;
    }

    public TCTokenResponse handleActivate(TCTokenRequest request) {
        ConnectionHandleType connectionHandle = null;
        TCTokenResponse response = new TCTokenResponse();
        byte[] requestedContextHandle = request.getContextHandle();
        String ifdName = request.getIFDName();
        BigInteger requestedSlotIndex = request.getSlotIndex();
        if (requestedContextHandle == null || ifdName == null || requestedSlotIndex == null) {
            connectionHandle = this.getFirstHandle(request.getCardType());
        } else {
            ConnectionHandleType requestedHandle = new ConnectionHandleType();
            requestedHandle.setContextHandle(requestedContextHandle);
            requestedHandle.setIFDName(ifdName);
            requestedHandle.setSlotIndex(requestedSlotIndex);
            Set<CardStateEntry> matchingHandles = this.cardStates.getMatchingEntries(requestedHandle);
            if (!matchingHandles.isEmpty()) {
                connectionHandle = matchingHandles.toArray(new CardStateEntry[0])[0].handleCopy();
            }
        }
        if (connectionHandle == null) {
            String msg = "No card available for the given ConnectionHandle.";
            logger.error(msg);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#cancellationByUser", msg));
            return response;
        }
        try {
            return this.doPAOS(request.getTCToken(), connectionHandle);
        }
        catch (DispatcherException w) {
            logger.error(w.getMessage(), w);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", w.getMessage()));
            return response;
        }
        catch (PAOSException w) {
            logger.error(w.getMessage(), w);
            Throwable innerException = w.getCause();
            if (innerException != null && innerException instanceof WSHelper.WSException) {
                response.setResult(((WSHelper.WSException)innerException).getResult());
            } else {
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", w.getMessage()));
            }
            return response;
        }
    }
}

