/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.util.Arrays;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;

public class TLVBitString {
    private TLV tlv;
    private byte[] data;

    public TLVBitString(TLV tlv, long tagNumWithClass) throws TLVException {
        if (tlv.getTagNumWithClass() != tagNumWithClass) {
            throw new TLVException("Type numbers don't match.");
        }
        this.tlv = tlv;
        this.data = tlv.getValue();
        this.data = Arrays.copyOfRange(this.data, 1, this.data.length);
    }

    public TLVBitString(TLV tlv) throws TLVException {
        this(tlv, Tag.BITSTRING_TAG.getTagNumWithClass());
    }

    public boolean isSet(int pos) {
        int i = pos / 8;
        int j = 1 << 7 - pos % 8;
        if (this.data != null && this.data.length > i) {
            byte k = this.data[i];
            return (k & j) != 0;
        }
        return false;
    }
}

