/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pqc.crypto.gmss;

import java.security.InvalidParameterException;

public class GMSSParameters {
    private int numOfLayers;
    private int[] heightOfTrees;
    private int[] winternitzParameter;
    private int[] K;

    public GMSSParameters(int layers, int[] heightOfTrees, int[] winternitzParameter, int[] K) throws InvalidParameterException {
        this.init(layers, heightOfTrees, winternitzParameter, K);
    }

    private void init(int layers, int[] heightOfTrees, int[] winternitzParameter, int[] K) throws InvalidParameterException {
        boolean valid = true;
        String errMsg = "";
        this.numOfLayers = layers;
        if (this.numOfLayers != winternitzParameter.length || this.numOfLayers != heightOfTrees.length || this.numOfLayers != K.length) {
            valid = false;
            errMsg = "Unexpected parameterset format";
        }
        for (int i = 0; i < this.numOfLayers; ++i) {
            if (K[i] < 2 || (heightOfTrees[i] - K[i]) % 2 != 0) {
                valid = false;
                errMsg = "Wrong parameter K (K >= 2 and H-K even required)!";
            }
            if (heightOfTrees[i] >= 4 && winternitzParameter[i] >= 2) continue;
            valid = false;
            errMsg = "Wrong parameter H or w (H > 3 and w > 1 required)!";
        }
        if (!valid) {
            throw new InvalidParameterException(errMsg);
        }
        this.heightOfTrees = (int[])heightOfTrees.clone();
        this.winternitzParameter = (int[])winternitzParameter.clone();
        this.K = (int[])K.clone();
    }

    public GMSSParameters(int keySize) throws InvalidParameterException {
        if (keySize <= 10) {
            int[] defh = new int[]{10};
            int[] defw = new int[]{3};
            int[] defk = new int[]{2};
            this.init(defh.length, defh, defw, defk);
        } else if (keySize <= 20) {
            int[] defh = new int[]{10, 10};
            int[] defw = new int[]{5, 4};
            int[] defk = new int[]{2, 2};
            this.init(defh.length, defh, defw, defk);
        } else {
            int[] defh = new int[]{10, 10, 10, 10};
            int[] defw = new int[]{9, 9, 9, 3};
            int[] defk = new int[]{2, 2, 2, 2};
            this.init(defh.length, defh, defw, defk);
        }
    }

    public int getNumOfLayers() {
        return this.numOfLayers;
    }

    public int[] getHeightOfTrees() {
        return (int[])this.heightOfTrees.clone();
    }

    public int[] getWinternitzParameter() {
        return (int[])this.winternitzParameter.clone();
    }

    public int[] getK() {
        return (int[])this.K.clone();
    }
}

