/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.openecard.bouncycastle.bcpg.BCPGInputStream;
import org.openecard.bouncycastle.bcpg.BCPGOutputStream;
import org.openecard.bouncycastle.bcpg.ContainedPacket;
import org.openecard.bouncycastle.bcpg.PublicKeyAlgorithmTags;

public class ExperimentalPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private int tag;
    private byte[] contents;

    ExperimentalPacket(int tag, BCPGInputStream in) throws IOException {
        this.tag = tag;
        if (in.available() != 0) {
            int b;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(in.available());
            while ((b = in.read()) >= 0) {
                bOut.write(b);
            }
            this.contents = bOut.toByteArray();
        } else {
            this.contents = new byte[0];
        }
    }

    public int getTag() {
        return this.tag;
    }

    public byte[] getContents() {
        byte[] tmp = new byte[this.contents.length];
        System.arraycopy(this.contents, 0, tmp, 0, tmp.length);
        return tmp;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(this.tag, this.contents, true);
    }
}

