/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ByteUtils {
    public static byte[] clone(byte[] input) {
        if (input == null) {
            return null;
        }
        byte[] ret = new byte[input.length];
        System.arraycopy(input, 0, ret, 0, input.length);
        return ret;
    }

    public static byte[] concatenate(byte[] x, byte[] y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        byte[] ret = new byte[x.length + y.length];
        System.arraycopy(x, 0, ret, 0, x.length);
        System.arraycopy(y, 0, ret, x.length, y.length);
        return ret;
    }

    public static byte[] concatenate(byte x, byte[] y) {
        return ByteUtils.concatenate(new byte[]{x}, y);
    }

    public static byte[] concatenate(byte[] x, byte y) {
        return ByteUtils.concatenate(x, new byte[]{y});
    }

    public static byte[] concatenate(byte x, byte y) {
        return ByteUtils.concatenate(new byte[]{x}, new byte[]{y});
    }

    public static byte[] cutLeadingNullBytes(byte[] input) {
        int i;
        if (input == null) {
            return null;
        }
        for (i = 0; i < input.length - 1 && input[i] == 0; ++i) {
        }
        return ByteUtils.copy(input, i, input.length - i);
    }

    public static byte[] cutLeadingNullByte(byte[] input) {
        if (input == null) {
            return null;
        }
        if (input[0] != 0) {
            return ByteUtils.clone(input);
        }
        return ByteUtils.copy(input, 1, input.length - 1);
    }

    public static byte[] copy(byte[] input, int offset, int length) {
        if (input == null) {
            return null;
        }
        byte[] tmp = new byte[length];
        System.arraycopy(input, offset, tmp, 0, length);
        return tmp;
    }

    public static boolean compare(byte[] x, byte[] y) {
        if (y == null) {
            return false;
        }
        if (x == null) {
            return false;
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == y[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(byte x, byte[] y) {
        return ByteUtils.compare(new byte[]{x}, y);
    }

    public static boolean compare(byte[] x, byte y) {
        return ByteUtils.compare(x, new byte[]{y});
    }

    public static boolean compare(byte x, byte y) {
        return ByteUtils.compare(new byte[]{x}, new byte[]{y});
    }

    public static String toHexString(byte[] bytes) {
        return ByteUtils.toHexString(bytes, "%02X", false);
    }

    public static String toHexString(byte[] bytes, boolean formatted) {
        return ByteUtils.toHexString(bytes, formatted, false);
    }

    public static String toHexString(byte[] bytes, boolean formatted, boolean addLinebreak) {
        if (formatted) {
            return ByteUtils.toHexString(bytes, "0x%02X ", addLinebreak);
        }
        return ByteUtils.toHexString(bytes, "%02X", addLinebreak);
    }

    private static String toHexString(byte[] bytes, String format, boolean addLinebreak) {
        if (bytes == null) {
            return null;
        }
        StringWriter writer = new StringWriter(bytes.length * 2);
        PrintWriter out = new PrintWriter(writer);
        for (int i = 1; i <= bytes.length; ++i) {
            out.printf(format, bytes[i - 1]);
            if (!addLinebreak || i % 16 != 0) continue;
            out.append("\n");
        }
        return writer.toString();
    }

    public static int toInteger(byte[] bytes) {
        if (bytes.length > 4 || bytes.length < 1) {
            throw new IllegalArgumentException("Size of byte array must be between 1 and 4.");
        }
        return (int)ByteUtils.toLong(bytes);
    }

    public static long toLong(byte[] bytes) {
        if (bytes.length > 8 || bytes.length < 1) {
            throw new IllegalArgumentException("Size of byte array must be between 1 and 8.");
        }
        long value = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            value |= (0xFFL & (long)bytes[bytes.length - 1 - i]) << i * 8;
        }
        return value;
    }

    public static short toShort(byte[] bytes) {
        if (bytes.length > 2 || bytes.length < 1) {
            throw new IllegalArgumentException("Size of byte array must be between 1 and 2.");
        }
        return (short)ByteUtils.toLong(bytes);
    }

    public static boolean isBitSet(int position, byte[] array) throws IllegalArgumentException {
        if (position < 0 || position >= array.length * 8) {
            throw new IllegalArgumentException("Position is invalid");
        }
        return (array[position / 8] & 128 >> position % 8) > 0;
    }

    public static void setBit(int position, byte[] array) throws IllegalArgumentException {
        if (position < 0 || position >= array.length * 8) {
            throw new IllegalArgumentException("Position is invalid");
        }
        int n = position / 8;
        array[n] = (byte)(array[n] | 128 >> position % 8);
    }
}

