/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio;

import java.io.File;
import java.io.FileNotFoundException;
import java.security.NoSuchAlgorithmException;
import javax.smartcardio.CardTerminals;
import org.openecard.common.ifd.TerminalFactory;
import org.openecard.common.util.LinuxLibraryFinder;
import org.openecard.scio.osx.SunOSXPCSC;

public class PCSCFactory
implements TerminalFactory {
    private static final String ALGORITHM = "PC/SC";
    private final javax.smartcardio.TerminalFactory terminalFactory;

    public PCSCFactory() throws FileNotFoundException, NoSuchAlgorithmException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            File libFile = LinuxLibraryFinder.getLibraryPath("pcsclite", "1");
            System.setProperty("sun.security.smartcardio.library", libFile.getAbsolutePath());
        } else if (osName.contains("OS X")) {
            this.terminalFactory = javax.smartcardio.TerminalFactory.getInstance(ALGORITHM, null, new SunOSXPCSC());
            return;
        }
        this.terminalFactory = javax.smartcardio.TerminalFactory.getInstance(ALGORITHM, null);
    }

    @Override
    public String getType() {
        return this.terminalFactory.getType();
    }

    @Override
    public CardTerminals terminals() {
        return this.terminalFactory.terminals();
    }
}

