/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DestroyChannel;
import java.util.Map;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.utils.CardUtils;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.FunctionType;
import org.openecard.common.sal.ProtocolStep;
import org.openecard.common.tlv.TLV;
import org.openecard.common.util.IntegerUtils;
import org.openecard.crypto.common.asn1.eac.CASecurityInfos;
import org.openecard.crypto.common.asn1.eac.SecurityInfos;
import org.openecard.crypto.common.asn1.eac.ef.EFCardAccess;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;
import org.openecard.sal.protocol.eac.ChipAuthentication;
import org.openecard.sal.protocol.eac.TerminalAuthentication;
import org.openecard.sal.protocol.eac.anytype.EAC2OutputType;
import org.openecard.sal.protocol.eac.anytype.EACAdditionalInputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChipAuthenticationStep
implements ProtocolStep<DIDAuthenticate, DIDAuthenticateResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ChipAuthenticationStep.class.getName());
    private final Dispatcher dispatcher;

    public ChipAuthenticationStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.DIDAuthenticate;
    }

    @Override
    public DIDAuthenticateResponse perform(DIDAuthenticate didAuthenticate, Map<String, Object> internalData) {
        DIDAuthenticateResponse response = new DIDAuthenticateResponse();
        byte[] slotHandle = didAuthenticate.getConnectionHandle().getSlotHandle();
        try {
            EACAdditionalInputType eacAdditionalInput = new EACAdditionalInputType(didAuthenticate.getAuthenticationProtocolData());
            EAC2OutputType eac2Output = eacAdditionalInput.getOutputType();
            TerminalAuthentication ta = new TerminalAuthentication(this.dispatcher, slotHandle);
            ChipAuthentication ca = new ChipAuthentication(this.dispatcher, slotHandle);
            ta.externalAuthentication(eacAdditionalInput.getSignature());
            CardUtils cardUtils = new CardUtils(this.dispatcher);
            byte[] efCardSecurity = cardUtils.readFile(slotHandle, (short)285);
            SecurityInfos securityInfos = (SecurityInfos)internalData.get("SecurityInfos");
            EFCardAccess efca = new EFCardAccess(securityInfos);
            CASecurityInfos cas = efca.getCASecurityInfos();
            byte[] oID = ObjectIdentifierUtils.getValue(cas.getCAInfo().getProtocol());
            byte[] keyID = IntegerUtils.toByteArray(cas.getCAInfo().getKeyID());
            ca.mseSetAT(oID, keyID);
            byte[] key = (byte[])internalData.get("PKPCD");
            byte[] responseData = ca.generalAuthenticate(key);
            TLV tlv = TLV.fromBER(responseData);
            byte[] nonce = tlv.findChildTags(129L).get(0).getValue();
            byte[] token = tlv.findChildTags(130L).get(0).getValue();
            DestroyChannel destroyChannel = new DestroyChannel();
            destroyChannel.setSlotHandle(didAuthenticate.getConnectionHandle().getSlotHandle());
            this.dispatcher.deliver(destroyChannel);
            eac2Output.setEFCardSecurity(efCardSecurity);
            eac2Output.setNonce(nonce);
            eac2Output.setToken(token);
            response.setResult(WSHelper.makeResultOK());
            response.setAuthenticationProtocolData(eac2Output.getAuthDataType());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResultUnknownError(e.getMessage()));
        }
        return response;
    }
}

