/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace.crypto;

import java.math.BigInteger;
import org.openecard.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.openecard.bouncycastle.jce.spec.ECParameterSpec;
import org.openecard.bouncycastle.math.ec.ECPoint;
import org.openecard.crypto.common.asn1.eac.PACEDomainParameter;
import org.openecard.ifd.protocol.pace.crypto.PACEKey;
import org.openecard.ifd.protocol.pace.crypto.PACEMapping;

public final class PACEGenericMapping
extends PACEMapping {
    private PACEKey mapKey;

    public PACEGenericMapping(PACEDomainParameter pdp) {
        super(pdp);
        this.mapKey = new PACEKey(pdp);
        this.mapKey.generateKeyPair();
    }

    @Override
    public PACEDomainParameter map(byte[] keyPICC, byte[] keyPCD) {
        if (this.pdp.isDH()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.pdp.isECDH()) {
            ECParameterSpec p = (ECParameterSpec)this.pdp.getParameter();
            ECPoint pkMapPICC = p.getCurve().decodePoint(keyPICC);
            BigInteger d = ((ECPrivateKeyParameters)this.mapKey.getPrivateKey()).getD();
            BigInteger s = new BigInteger(1, keyPCD);
            ECPoint h = pkMapPICC.multiply(p.getH().multiply(d));
            ECPoint newG = p.getG().multiply(s).add(h);
            ECParameterSpec parameter = new ECParameterSpec(p.getCurve(), newG, p.getN(), p.getH());
            this.pdp.setParameter(parameter);
            return this.pdp;
        }
        throw new IllegalArgumentException();
    }

    public PACEKey getMappingKey() {
        return this.mapKey;
    }
}

