/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal;

import iso.std.iso_iec._24727.tech.schema.CardApplicationEndSession;
import iso.std.iso_iec._24727.tech.schema.CardApplicationEndSessionResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationStartSession;
import iso.std.iso_iec._24727.tech.schema.CardApplicationStartSessionResponse;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDCreate;
import iso.std.iso_iec._24727.tech.schema.DIDCreateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDDelete;
import iso.std.iso_iec._24727.tech.schema.DIDDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DIDGet;
import iso.std.iso_iec._24727.tech.schema.DIDGetResponse;
import iso.std.iso_iec._24727.tech.schema.DIDUpdate;
import iso.std.iso_iec._24727.tech.schema.DIDUpdateResponse;
import iso.std.iso_iec._24727.tech.schema.Decipher;
import iso.std.iso_iec._24727.tech.schema.DecipherResponse;
import iso.std.iso_iec._24727.tech.schema.Encipher;
import iso.std.iso_iec._24727.tech.schema.EncipherResponse;
import iso.std.iso_iec._24727.tech.schema.GetRandom;
import iso.std.iso_iec._24727.tech.schema.GetRandomResponse;
import iso.std.iso_iec._24727.tech.schema.Hash;
import iso.std.iso_iec._24727.tech.schema.HashResponse;
import iso.std.iso_iec._24727.tech.schema.RequestType;
import iso.std.iso_iec._24727.tech.schema.ResponseType;
import iso.std.iso_iec._24727.tech.schema.Sign;
import iso.std.iso_iec._24727.tech.schema.SignResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyCertificate;
import iso.std.iso_iec._24727.tech.schema.VerifyCertificateResponse;
import iso.std.iso_iec._24727.tech.schema.VerifySignature;
import iso.std.iso_iec._24727.tech.schema.VerifySignatureResponse;
import java.util.ArrayList;
import java.util.TreeMap;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.WSHelper;
import org.openecard.common.sal.FunctionType;
import org.openecard.common.sal.ProtocolStep;

public class Protocol {
    protected final TreeMap<String, Object> internalData = new TreeMap();
    protected final ArrayList<ProtocolStep> steps = new ArrayList();
    protected int curStep = 0;

    public TreeMap<String, Object> getInternalData() {
        return this.internalData;
    }

    private boolean hasNextStep() {
        return this.steps.size() > this.curStep;
    }

    public boolean hasNextStep(FunctionType functionName) {
        if (this.hasNextStep()) {
            return this.steps.get(this.curStep).getFunctionType() == functionName;
        }
        return false;
    }

    public boolean isFinished() {
        return !this.hasNextStep();
    }

    private ProtocolStep next() {
        if (this.steps.size() > this.curStep) {
            ProtocolStep step = this.steps.get(this.curStep);
            ++this.curStep;
            return step;
        }
        return null;
    }

    private static ResponseType perform(Class<? extends ResponseType> responseClass, ProtocolStep step, RequestType request, TreeMap<String, Object> internalData) {
        if (step == null) {
            String msg = "There is no applicable protocol step at this point in the protocol flow.";
            Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#inappropriateProtocolForAction", msg);
            return (ResponseType)WSHelper.makeResponse(responseClass, r);
        }
        return step.perform(request, internalData);
    }

    public CardApplicationStartSessionResponse cardApplicationStartSession(CardApplicationStartSession param) {
        return (CardApplicationStartSessionResponse)Protocol.perform(CardApplicationEndSessionResponse.class, this.next(), param, this.internalData);
    }

    public CardApplicationEndSessionResponse cardApplicationEndSession(CardApplicationEndSession param) {
        return (CardApplicationEndSessionResponse)Protocol.perform(CardApplicationEndSessionResponse.class, this.next(), param, this.internalData);
    }

    public EncipherResponse encipher(Encipher param) {
        return (EncipherResponse)Protocol.perform(EncipherResponse.class, this.next(), param, this.internalData);
    }

    public DecipherResponse decipher(Decipher param) {
        return (DecipherResponse)Protocol.perform(DecipherResponse.class, this.next(), param, this.internalData);
    }

    public GetRandomResponse getRandom(GetRandom param) {
        return (GetRandomResponse)Protocol.perform(GetRandomResponse.class, this.next(), param, this.internalData);
    }

    public HashResponse hash(Hash param) {
        return (HashResponse)Protocol.perform(HashResponse.class, this.next(), param, this.internalData);
    }

    public SignResponse sign(Sign param) {
        return (SignResponse)Protocol.perform(SignResponse.class, this.next(), param, this.internalData);
    }

    public VerifySignatureResponse verifySignature(VerifySignature param) {
        return (VerifySignatureResponse)Protocol.perform(VerifySignatureResponse.class, this.next(), param, this.internalData);
    }

    public VerifyCertificateResponse verifyCertificate(VerifyCertificate param) {
        return (VerifyCertificateResponse)Protocol.perform(VerifyCertificateResponse.class, this.next(), param, this.internalData);
    }

    public DIDCreateResponse didCreate(DIDCreate param) {
        return (DIDCreateResponse)Protocol.perform(DIDCreateResponse.class, this.next(), param, this.internalData);
    }

    public DIDGetResponse didGet(DIDGet param) {
        return (DIDGetResponse)Protocol.perform(DIDGetResponse.class, this.next(), param, this.internalData);
    }

    public DIDUpdateResponse didUpdate(DIDUpdate param) {
        return (DIDUpdateResponse)Protocol.perform(DIDUpdateResponse.class, this.next(), param, this.internalData);
    }

    public DIDDeleteResponse didDelete(DIDDelete param) {
        return (DIDDeleteResponse)Protocol.perform(DIDDeleteResponse.class, this.next(), param, this.internalData);
    }

    public DIDAuthenticateResponse didAuthenticate(DIDAuthenticate param) {
        return (DIDAuthenticateResponse)Protocol.perform(DIDAuthenticateResponse.class, this.next(), param, this.internalData);
    }

    public boolean needsSM() {
        return false;
    }

    public byte[] applySM(byte[] commandAPDU) {
        return commandAPDU;
    }

    public byte[] removeSM(byte[] responseAPDU) {
        return responseAPDU;
    }
}

