/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.common;

import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;
import org.openecard.common.apdu.common.CardAPDU;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CardResponseAPDU
extends CardAPDU {
    private static final Logger logger = LoggerFactory.getLogger(CardResponseAPDU.class);
    private byte[] trailer;

    public CardResponseAPDU() {
        this.trailer = new byte[2];
    }

    public CardResponseAPDU(byte[] responseAPDU) {
        this.trailer = new byte[2];
        this.data = new byte[responseAPDU.length - 2];
        System.arraycopy(responseAPDU, 0, this.data, 0, responseAPDU.length - 2);
        System.arraycopy(responseAPDU, responseAPDU.length - 2, this.trailer, 0, 2);
    }

    public CardResponseAPDU(byte[] data, byte[] trailer) {
        this.setData(data);
        this.setTrailer(trailer);
    }

    public CardResponseAPDU(TransmitResponse transmitResponse) {
        this(transmitResponse.getOutputAPDU().get(0));
    }

    public static byte[] getData(byte[] responseAPDU) {
        if (responseAPDU.length < 2) {
            throw new IllegalArgumentException("Malformed APDU");
        }
        return ByteUtils.copy(responseAPDU, 0, responseAPDU.length - 2);
    }

    public void setTrailer(byte[] trailer) {
        this.setTrailer(trailer);
    }

    public byte[] getTrailer() {
        return this.trailer;
    }

    public static byte[] getTrailer(byte[] responseAPDU) {
        if (responseAPDU.length < 2) {
            throw new IllegalArgumentException("Malformed APDU");
        }
        return ByteUtils.copy(responseAPDU, responseAPDU.length - 2, 2);
    }

    public byte getSW1() {
        return (byte)(this.trailer[0] & 0xFF);
    }

    protected void setSW1(byte sw1) {
        this.trailer[0] = sw1;
    }

    public byte getSW2() {
        return (byte)(this.trailer[1] & 0xFF);
    }

    protected void setSW2(byte sw2) {
        this.trailer[1] = sw2;
    }

    public short getSW() {
        return (short)((this.trailer[0] & 0xFF) << 8 | this.trailer[1] & 0xFF);
    }

    public byte[] getStatusBytes() {
        return this.getTrailer();
    }

    public String getStatusMessage() {
        return CardCommandStatus.getMessage(this.getTrailer());
    }

    protected void setStatusBytes(byte[] statusbytes) {
        this.setTrailer(statusbytes);
    }

    public boolean isNormalProcessed() {
        return Arrays.equals(this.trailer, new byte[]{-112, 0});
    }

    public boolean isWarningProcessed() {
        return this.trailer[0] == 98 || this.trailer[0] == 99;
    }

    public boolean isExecutionError() {
        return this.trailer[0] == 100 || this.trailer[0] == 101 || this.trailer[0] == 102;
    }

    public boolean isCheckingError() {
        if ((this.trailer[0] & 0xF0) == 96) {
            for (int b = 7; b < 15; b = (int)((byte)(b + 1))) {
                if ((this.trailer[0] & 0xF) != b) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPositiveResponse(List<byte[]> responses) {
        for (int i = 0; i < responses.size(); ++i) {
            if (!Arrays.equals(responses.get(i), this.trailer)) continue;
            return true;
        }
        return false;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.data.length + 2);
        try {
            baos.write(this.trailer);
            baos.write(this.data);
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
        return baos.toByteArray();
    }

    public String toHexString() {
        return ByteUtils.toHexString(this.toByteArray());
    }

    public String toString() {
        return ByteUtils.toHexString(this.toByteArray(), true);
    }
}

